% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_gradient2.R
\name{rule_fill_gradient2_}
\alias{rule_fill_gradient2_}
\title{Fill column with divergent colour gradient (standard evaluation)}
\usage{
rule_fill_gradient2_(columns, expression = ~., low = scales::muted("red"),
  mid = "white", high = scales::muted("blue"), midpoint = NA,
  space = "Lab", na.value = "#7F7F7F", limits = NA, lockcells = FALSE)
}
\arguments{
\item{columns}{a character vector with the column names or a list with
dplyr select helpers given as formulas or a combination of both}

\item{expression}{a formula to be evaluated with the data that will be used
to determine which cells are to be coloured. See the examples
to use it programmatically}

\item{low}{colour for low end of gradient.}

\item{mid}{colour for mid point}

\item{high}{colour for high end of gradient.}

\item{midpoint}{the value used for the middle color (the median by default)}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{fill color for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\description{
Fills the background color of a column using a three colors gradient based on
the values of an expression
}
\examples{
data(iris)
condformat(iris[1:10,]) + rule_fill_gradient2_(columns=c("Sepal.Length"))
condformat(iris[1:10,]) + rule_fill_gradient2_("Species",
   expression= ~Sepal.Length-Sepal.Width)

# Use it programmatically
color_column <- function(x, column) {
  condformat(x) +
    rule_fill_gradient2_(column, expression=~ uq(as.name(column)))
}
color_column(iris[c(1,51,101),], "Sepal.Length")

}
\seealso{
Other rule: \code{\link{rule_fill_discrete_}},
  \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient2}},
  \code{\link{rule_fill_gradient_}},
  \code{\link{rule_fill_gradient}}
}

