% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_gradient2.R
\name{rule_fill_gradient2}
\alias{rule_fill_gradient2}
\alias{rule_fill_gradient2_}
\title{Fill column with divergent colour gradient}
\usage{
rule_fill_gradient2(..., expression, low = scales::muted("red"),
  mid = "white", high = scales::muted("blue"), midpoint = NA,
  space = "Lab", na.value = "#7F7F7F", limits = NA, lockcells = FALSE)

rule_fill_gradient2_(columns, expression, low = scales::muted("red"),
  mid = "white", high = scales::muted("blue"), midpoint = NA,
  space = "Lab", na.value = "#7F7F7F", limits = NA, lockcells = FALSE,
  env = parent.frame())
}
\arguments{
\item{...}{Comma separated list of unquoted column names.
If expression is also given, then this list can use any of the
\code{\link[dplyr]{select}} syntax possibilities.}

\item{expression}{An expression to be evaluated with the data frame this rule applies to.
It should evaluate to a numeric vector, that will be used
to compute the color gradient values.
In rule_fill_gradient_, a character string.}

\item{low}{colour for low end of gradient.}

\item{mid}{colour for mid point}

\item{high}{colour for high end of gradient.}

\item{midpoint}{the value used for the middle color (the median by default)}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{fill color for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}

\item{columns}{[SE] a character vector with the column names (Only in rule_fill_gradient2_)}

\item{env}{[SE] the environment where `expression` is to be evaluated (Only in rule_fill_gradient2_)}
}
\value{
The condformat_tbl object, with the added formatting information
}
\description{
Fills the background color of a column using a three colors gradient based on
the values by an expression
}
\examples{
data(iris)
condformat(iris[c(1:5, 70:75, 120:125), ]) +
 rule_fill_gradient2(Sepal.Length)
condformat(iris[c(1:5, 70:75, 120:125), ]) +
 rule_fill_gradient2(Species, expression=Sepal.Length - Sepal.Width)
data(iris)
condformat(iris) + rule_fill_gradient2_(columns=c("Sepal.Length"))
condformat(iris) + rule_fill_gradient2_("Species", expression="Sepal.Length-Sepal.Width")
}
\seealso{
Other rule: \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient}}

Other rule: \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient}}
}

