% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_surv.R
\name{curve_surv}
\alias{curve_surv}
\title{Consonance Functions For Survival Data}
\usage{
curve_surv(data, x, steps = 10000, cores = getOption("mc.cores", 1L),
  table = TRUE)
}
\arguments{
\item{data}{Object where the Cox model is stored, typically a list produced by the
'survival' package.}

\item{x}{Predictor of interest within the survival model for which the
consonance intervals should be computed.}

\item{steps}{Indicates how many consonance intervals are to be calculated at
various levels. For example, setting this to 100 will produce 100 consonance
intervals from 0 to 100. Setting this to 10000 will produce more consonance
levels. By default, it is set to 1000. Increasing the number substantially
is not recommended as it will take longer to produce all the intervals and
store them into a dataframe.}

\item{cores}{Select the number of cores to use in  order to compute the intervals
The default is 1 core.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\value{
A list with 3 items where the dataframe of values is in the first
object, the values needed to calculate the density function in the second,
and the table for the values in the third if table = TRUE.
}
\description{
Computes thousands of consonance (confidence) intervals for the chosen
parameter in the Cox model computed by the 'survival' package and places
the interval limits for each interval level into a data frame along
with the corresponding p-value and s-value.
}
\examples{
\dontrun{
library(carData)
Rossi[1:5, 1:10]
library(survival)

mod.allison <- coxph(Surv(week, arrest) ~ fin + age + race + wexp + mar + paro + prio,
  data = Rossi
)
mod.allison

z <- curve_surv(mod.allison, "prio")
}
}
