% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_lmer.R
\name{curve_lmer}
\alias{curve_lmer}
\title{Consonance Functions For Linear & Non-Linear Mixed-Effects Models.}
\usage{
curve_lmer(object, parm, method = "profile", zeta = NULL, nsim = NULL,
  FUN = NULL, boot.type = NULL, steps = 1000, mc.cores = 1,
  table = FALSE)
}
\arguments{
\item{object}{The statistical model of interest from lme4 is to be indicated here.}

\item{parm}{The variable of interest from the model (coefficients, intercept)
for which the intervals are to be produced.}

\item{method}{Chooses the method to be used to calculate the
consonance intervals. There are currently four methods:
"default", "wald", "lm", and "boot". The "default" method uses the profile
likelihood method to compute intervals and can be used for models created by
the 'lm' function. The "wald" method is typicallywhat most people are
familiar with when computing intervals based on the calculated standard error.
The "lm" method allows this function to be used for specific scenarios like
logistic regression and the 'glm' function. The "boot" method allows for
bootstrapping at certain levels.}

\item{zeta}{(for method = "profile" only:)
likelihood cutoff (if not specified, as by default, computed from level).}

\item{nsim}{number of simulations for parametric bootstrap intervals.}

\item{FUN}{function; if NULL, an internal function that returns the
fixed-effect parameters as well as the random-effect parameters on
the standard deviation/correlationscale will be used.}

\item{boot.type}{bootstrap confidence interval type, as described in boot.c i.
Methods stud and bca are unavailable because they
require additional components to be calculated.}

\item{steps}{Indicates how many consonance intervals are to be calculated at
various levels. For example, setting this to 100 will produce 100 consonance
intervals from 0 to 100. Setting this to 10000 will produce more consonance
levels. By default, it is set to 1000. Increasing the number substantially
is not recommended as it will take longer to produce all the intervals and
store them into a dataframe.}

\item{mc.cores}{For parallel processing. Defaults to 1 core.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\value{
A list with 3 items where the dataframe of values is in the first
object, the values needed to calculate the density function in the second,
and the table for the values in the third if table = TRUE.
}
\description{
Computes thousands of consonance (confidence) intervals for
the chosen parameter in the selected lme4 model and places
the interval limits for each interval level into a data frame along
with the corresponding p-values and s-values.
}
