% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{nodesum}
\alias{nodesum}
\alias{nodeplots}
\title{Summarize contrast tree}
\usage{
nodesum(tree, x, y, z, w = rep(1, nrow(x)), doplot = FALSE)

nodeplots(
  tree,
  x,
  y,
  z,
  w = rep(1, nrow(x)),
  nodes = NULL,
  xlim = NULL,
  ylim = NULL,
  pts = "FALSE",
  span = 0.15
)
}
\arguments{
\item{tree}{model object output from contrast() or prune()}

\item{x}{training input predictor data matrix or data frame in same format as in contrast()}

\item{y}{vector, or matrix containing training data input outcome values or censoring intervals for each observation in same format as in contrast()}

\item{z}{vector containing values of a second contrasting quantity for each observation in same observation format as in contrast()}

\item{w}{observation weights}

\item{doplot}{a flag to display/not display plots of output quantities}

\item{nodes}{selected tree terminal node identifiers. Default is all terminal nodes}

\item{xlim}{x-axis limit}

\item{ylim}{y-axis limit}

\item{pts}{logical flag indicating whether to show \code{y}-values as circles/points (\code{type = 'pp'} only)}

\item{span}{running median smoother span (\code{type = 'diff'} only)}
}
\value{
a named list of four items:
\itemize{
\item \code{nodes} the tree terminal node identifiers
\item \code{cri} the terminal node criterion values (depends on contrast type see above)
\item \code{wt} sum of weights in each terminal node
\item \code{avecri} weighted criterion average over all terminal nodes
}
}
\description{
Summarize contrast tree

Show graphical terminal node summaries
}
\details{
The graphical representations of terminal node contrasts depend on the tree type
graphical representations of terminal node contrasts depending on tree type
-\code{type = 'dist'} implies CDFs of y and z in each terminal node. (Only top nine nodes are shown). Note that y can be censored (see above)
-\code{type = 'diff'} implies plot y versus z in each terminal node. (Only top nine nodes are shown).
-\code{type = 'class'} implies barplot of misclassification risk (upper) amd total weight (lower) in each terminal node
-\code{type = 'prob'} implies upper barplot contrasting empirical (blue) and predicted (red) \eqn{p(y=1)} in each terminal node. Lower barplot showing total weight in each terminal node.
\itemize{
\item type = 'quant' => upper barplot of fraction of y-values greater than or equal to corresponding z-values (quantile prediction) in each terminal node. Horizontal line reflects specified target quantile. Lower barplot showing total  weight in each terminal node.
\item \code{type = 'diffmean'} or \code{type = 'maxmean'} implies upper barplot contrasting y-mean (blue) and z-mean (red) in each terminal node. Lower barplot showing total weight in each terminal node.
}
}
\seealso{
\code{\link[=contrast]{contrast()}}
}
