% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_nns.R
\name{find_nns}
\alias{find_nns}
\title{Return nearest neighbors based on cosine similarity}
\usage{
find_nns(
  target_embedding,
  pre_trained,
  N = 5,
  candidates = NULL,
  norm = "l2",
  stem = FALSE,
  language = "porter"
)
}
\arguments{
\item{target_embedding}{(numeric) 1 x D matrix. D = dimensions of pretrained embeddings.}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{N}{(numeric) number of nearest neighbors to return.}

\item{candidates}{(character) vector of candidate features for nearest neighbors}

\item{norm}{(character) - how to compute similarity (see ?text2vec::sim2):
\describe{
\item{\code{"l2"}}{cosine similarity}
\item{\code{"none"}}{inner product}
}}

\item{stem}{(logical) - whether to stem candidates when evaluating nns. Default is FALSE.
If TRUE, candidate stems are ranked by their average cosine similarity to the target.
We recommend you remove misspelled words from candidate set \code{candidates} as these can
significantly influence the average.}

\item{language}{the name of a recognized language, as returned by
     \code{\link[SnowballC]{getStemLanguages}}, or a two- or three-letter ISO-639
     code corresponding to one of these languages (see references for
     the list of codes).
  }
}
\value{
(character) vector of nearest neighbors to target
}
\description{
Return nearest neighbors based on cosine similarity
}
\examples{
find_nns(target_embedding = cr_glove_subset['immigration',],
         pre_trained = cr_glove_subset, N = 5,
         candidates = NULL, norm = "l2", stem = FALSE)
}
\keyword{find_nns}
