% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_commodities_table.R
\name{ct_commodities_table}
\alias{ct_commodities_table}
\title{Extract commodity code look up table from UN Comtrade}
\usage{
ct_commodities_table(type = c("HS", "HS1992", "HS1996", "HS2002", "HS2007",
  "HS2012", "SITC", "SITCrev1", "SITCrev2", "SITCrev3", "SITCrev4", "BEC",
  "EB02"), baseurl = "https://comtrade.un.org/", path = "data/cache/")
}
\arguments{
\item{type}{Trade data classification scheme to use, see "Details" for a 
list of the valid inputs.}

\item{baseurl}{The base url of the UN Comtrade website.}

\item{path}{The path url string that points to the correct directory.}
}
\value{
A dataframe of commodities, commodity codes and parent codes, 
 downloaded from UN Comtrade.
}
\description{
Returns a dataframe of commodities, commodity codes and parent codes, 
downloaded from UN Comtrade. For use with the UN Comtrade API, full API 
docs can be found at \url{https://comtrade.un.org/data/doc/api/}
}
\details{
The default for param \code{type} is \code{HS}. Below is a list of 
 all valid inputs with a very brief description for each, for more 
 information on each of these types, see 
 \url{https://comtrade.un.org/data/doc/api/#DataAvailabilityRequests}
 \itemize{
 \item \code{HS}: Harmonized System (HS), as reported
 \item \code{HS1992}: HS 1992
 \item \code{HS1996}: HS 1996
 \item \code{HS2002}: HS 2002
 \item \code{HS2007}: HS 2007
 \item \code{HS2012}: HS 2012
 \item \code{SITC}: Standard International Trade Classification (SITC), as 
   reported
 \item \code{SITCrev1}: SITC Revision 1
 \item \code{SITCrev2}: SITC Revision 2
 \item \code{SITCrev3}: SITC Revision 3
 \item \code{SITCrev4}: SITC Revision 4
 \item \code{BEC}: Broad Economic Categories
 \item \code{EB02}: Extended Balance of Payments Services Classification
 }
 
 The default for param \code{baseurl} is \code{"https://comtrade.un.org/"}, 
 and should only be changed if the Comtrade website url changes.
 
 The default for param \code{path} is \code{"data/cache/"}, and should only 
 be changed if the Comtrade website changes or if Comtrade changes the url 
 path that points to the JSON commodity tables.
}
\examples{
\dontrun{
ct_commodities_table("HS")
ct_commodities_table("SITCrev2")
}
}
