% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compboost.R
\name{Compboost}
\alias{Compboost}
\title{Compboost API}
\format{\code{\link{R6Class}} object.}
\description{
\code{Compboost} wraps the \code{S4} class system exposed by \code{Rcpp} to make defining
objects, adding objects, the training and taking predictions, and plotting much easier.
As already mentioned, the \code{Compboost} class is just a wrapper and hence compatible
with the most \code{S4} classes. This together defines the compboost API.
}
\section{Usage}{

\preformatted{
cboost = Compboost$new(data, target, optimizer = OptimizerCoordinateDescent$new(), loss,
  learning.rate = 0.05)

cboost$addLogger(logger, use.as.stopper = FALSE, logger.id, ...)

cbboost$addBaselearner(features, id, bl.factory, data.source = InMemoryData,
  data.target = InMemoryData, ...)

cbboost$train(iteration = 100, trace = TRUE)

cboost$getCurrentIteration()

cboost$predict(newdata = NULL)

cboost$getInbagRisk()

cboost$getSelectedBaselearner()

cboost$getEstimatedCoef()

cboost$plot(blearner.type = NULL, iters = NULL, from = NULL, to = NULL, length.out = 1000)

cboost$getBaselearnerNames()

cboost$prepareData(newdata)

}
}

\section{Arguments}{

\strong{For Compboost$new()}:
\describe{
\item{\code{data}}{[\code{data.frame}]\cr
  Data used for training.
}
\item{\code{target}}{[\code{character(1)}]\cr
  Character naming the target. It is necessary that target is available as column in data.
}
\item{\code{optimizer}}{[\code{S4 Optimizer}]\cr
  Optimizer used for the fitting process given as initialized \code{S4 Optimizer} class.
  Default is the \code{OptimizerCoordinateDescent}.
}
\item{\code{loss}}{[\code{S4 Loss}]\cr
  Loss as initialized \code{S4 Loss} which is used to calculate pseudo residuals and the
  empirical risk. Note that the loss needs match the data type of the target variable.
  See the details for possible choices.
}
\item{\code{learning.rage}}{[\code{numeric(1)}]\cr
  Learning rate used to shrink estimated parameter in each iteration. The learning rate
  remains constant during the training and has to be between 0 and 1.
}
}

\strong{For cboost$addLogger()}:
\describe{
\item{\code{logger}}{[\code{S4 Logger}]\cr
  Logger which are registered within a logger list. The objects must be given as uninitialized
  \code{S4 Logger} class. See the details for possible choices.
}
\item{\code{use.as.stopper}}{[\code{logical(1)}]\cr
  Logical indicating whether the new logger should also be used as stopper. Default value is
  \code{FALSE}.
}
\item{\code{logger.id}}{[\code{character(1)}]\cr
  Id of the new logger. This is necessary to e.g. register multiple risk logger.
}
\item{}{\code{...}\cr
  Further arguments passed to the constructor of the \code{S4 Logger} class specified in
  \code{logger}. For possible arguments see details or the help pages (e.g. \code{?LoggerIteration})
  of the \code{S4} classes.
}
}

\strong{For cboost$addBaselearner()}:
\describe{
\item{\code{features}}{[\code{character()}]\cr
  Vector of column names which are used as input data matrix for a single base-learner. Note that not 
  every base-learner supports the use of multiple features (e.g. the spline base-learner).
}
\item{\code{id}}{[\code{character(1)}]\cr
  Id of the base-learners. This is necessary since it is possible to define multiple learners with the same underlying data.
}
\item{\code{bl.factory}}{[\code{S4 Factory}]\cr
  Uninitialized base-learner factory represented as \code{S4 Factory} class. See the details
  for possible choices.
}
\item{\code{data.source}}{[\code{S4 Data}]\cr
  Data source object. At the moment just in memory is supported.
}
\item{\code{data.target}}{[\code{S4 Data}]\cr
  Data target object. At the moment just in memory is supported.
}
\item{}{\code{...}\cr
  Further arguments passed to the constructor of the \code{S4 Factory} class specified in
  \code{bl.factory}. For possible arguments see the help pages (e.g. \code{?BaselearnerPSplineFactory})
  of the \code{S4} classes.
}
}

\strong{For cboost$train()}:
\describe{
\item{\code{iteration}}{[\code{integer(1)}]\cr
  Set the algorithm at \code{iteration}. Note: This argument is ignored if this is the first
  training and an iteration logger is already specified. For further uses the algorithm automatically
  continues training if \code{iteration} is set to an value larger than the already trained iterations.
}
\item{\code{trace}}{[\code{integer(1)}]\cr
  Integer indicating how often a trace should be printed. Specifying \code{trace = 10}, then every
  10th iteration is printed. If no trace should be printed set \code{trace = 0}. Default is
  -1 which means that we set \code{trace} at a value that 40 iterations are printed.
}
}

\strong{For cboost$predict()}:
\describe{
\item{\code{newdata}}{[\code{data.frame()}]\cr
	 Data to predict on. If \code{NULL} predictions on the training data are returned.
}
}
\strong{For cboost$plot()}:
\describe{
\item{\code{blearner.type}}{[\code{character(1)}]\cr
	 Character name of the base-learner to plot the additional contribution to the response.
}
\item{\code{iters}}{[\code{integer()}]\cr
	 Integer vector containing the iterations the user wants to illustrate. 
}
\item{\code{from}}{[\code{numeric(1)}]\cr
	 Lower bound for plotting (should be smaller than \code{to}).
}
\item{\code{to}}{[\code{numeric(1)}]\cr
	 Upper bound for plotting (should be greater than \code{from}).
}
\item{\code{length.out}}{[\code{integer(1)}]\cr
	 Number of equidistant points between \code{from} and \code{to} used for plotting.
}
}
}

\section{Details}{

  \strong{Loss}\cr
  Available choices for the loss are:
	 \itemize{
  \item
    \code{LossQuadratic} (Regression)

  \item
    \code{LossAbsolute} (Regression)

  \item
    \code{LossBinomial} (Binary Classification)

  \item
    \code{LossCustom} (Custom)

  \item
    \code{LossCustomCpp} (Custom)
  }
  (For each loss also take a look at the help pages (e.g. \code{?LossBinomial}) and the
  \code{C++} documentation for details about the underlying formulas)

  \strong{Logger}\cr
  Available choices for the logger are:
  \itemize{
  \item
    \code{LoggerIteration}: Log current iteration. Additional arguments:
    \describe{
      \item{\code{max_iterations} [\code{integer(1)}]}{
        Maximal number of iterations.
      }
    }

  \item
    \code{LoggerTime}: Log already elapsed time. Additional arguments:
    \describe{
      \item{\code{max_time} [\code{integer(1)}]}{
        Maximal time for the computation.
      }
      \item{\code{time_unit} [\code{character(1)}]}{
        Character to specify the time unit. Possible choices are \code{minutes}, \code{seconds}, or \code{microseconds}.
      }
    }

  \item
    \code{LoggerInbagRisk}:
    \describe{
      \item{\code{used_loss} [\code{S4 Loss}]}{
        Loss as initialized \code{S4 Loss} which is used to calculate the empirical risk. See the
        details for possible choices.
      }
      \item{\code{eps_for_break} [\code{numeric(1)}]}{
        This argument is used if the logger is also used as stopper. If the relative improvement
        of the logged inbag risk falls above this boundary the stopper breaks the algorithm.
      }
    }

  \item
    \code{LoggerOobRisk}:
    \describe{
      \item{\code{used_loss} [\code{S4 Loss}]}{
        Loss as initialized \code{S4 Loss} which is used to calculate the empirical risk. See the
        details for possible choices.
      }
      \item{\code{eps_for_break} [\code{numeric(1)}]}{
        This argument is used if the logger is also used as stopper. If the relative improvement
        of the logged inbag risk falls above this boundary the stopper breaks the algorithm.
      }
      \item{\code{oob_data} [\code{list}]}{
        A list which contains data source objects which corresponds to the source data of each registered factory.
        The source data objects should contain the out of bag data. This data is then used to calculate the
        new predictions in each iteration.
      }
      \item{\code{oob_response} [\code{vector}]}{
        Vector which contains the response for the out of bag data given within \code{oob_data}.
      }
    }
  }
  \strong{Note}:
  \itemize{
  \item
    Even if you do not use the logger as stopper you have to define the arguments such as \code{max_time}.

  \item
    We are aware of that the style guide here is not consistent with the \code{R6} arguments. Nevertheless, using
    \code{_} as word separator is due to the used arguments within \code{C++}.
  }
}

\section{Fields}{

\describe{
\item{\code{data} [\code{data.frame}]}{
  Data used for training the algorithm.
}
\item{\code{response} [\code{vector}]}{
  Response given as vector.
}
\item{\code{target} [\code{character(1)}]}{
	 Name of the Response.
}
\item{\code{id} [\code{character(1)}]}{
	 Value to identify the data. By default name of \code{data}, but can be overwritten.
}
\item{\code{optimizer} [\code{S4 Optimizer}]}{
  Optimizer used within the fitting process.
}
\item{\code{loss} [\code{S4 Loss}]}{
  Loss used to calculate pseudo residuals and empirical risk.
}
\item{\code{learning.rate} [\code{numeric(1)}]}{
  Learning rate used to shrink the estimated parameter in each iteration.
}
\item{\code{model} [\code{S4 Compboost_internal}]}{
  Internal \code{S4 Compboost_internal} class on which the main operations are called.
}
\item{\code{bl.factory.list} [\code{S4 FactoryList}]}{
  List of all registered factories represented as \code{S4 FactoryList} class.
}
\item{\code{positive.category} [\code{character(1)}]}{
  Character containing the name of the positive class in the case of classification.
}
\item{\code{stop.if.all.stoppers.fulfilled} [\code{logical(1)}]}{
  Logical indicating whether all stopper should be used simultaneously or if it is sufficient
  that the first stopper which is fulfilled breaks the algorithm.
}
}
}

\section{Methods}{

\describe{
\item{\code{addLogger}}{method to add a logger to the algorithm (Note: This is just possible before the training).}
\item{\code{addBaselearner}}{method to add a new base-learner factories to the algorithm (Note: This is just possible before the training).}
\item{\code{getCurrentIteration}}{method to get the current iteration on which the algorithm is set.}
\item{\code{train}}{method to train the algorithm.}
\item{\code{predict}}{method to predict on a trained object.}
\item{\code{getSelectedBaselearner}}{method to get a character vector of selected base-learner.}
\item{\code{getEstimatedCoef}}{method to get a list of estimated coefficient for each selected base-learner.}
\item{\code{plot}}{method to plot the \code{Compboost} object.}
\item{\code{getBaselearnerNames}}{method to get names of registered factories.}
}
}

\examples{
cboost = Compboost$new(mtcars, "mpg", loss = LossQuadratic$new())
cboost$addBaselearner("hp", "spline", BaselearnerPSpline, degree = 3,
  n.knots = 10, penalty = 2, differences = 2)
cboost$train(1000)

table(cboost$getSelectedBaselearner())
cboost$plot("hp_spline")
}
