% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BlearnerFactoryList}
\alias{BlearnerFactoryList}
\title{Base-learner factory list to define the set of base-learners}
\format{\code{\link{S4}} object.}
\description{
\code{BlearnerFactoryList} creates an object in which base-learner factories
can be registered. This object can then be passed to compboost as set of
base-learner which is used by the optimizer to get the new best
base-learner.
}
\section{Usage}{

\preformatted{
BlearnerFactoryList$new()
}
}

\section{Details}{


  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classblearnerlist_1_1_baselearner_factory_list.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{registerFactory(BaselearnerFactory)}}{Takes a object of the
  class \code{BaseLearnerFactory} and adds this factory to the set of
  base-learner.}
\item{\code{printRegisteredFactories()}}{Get all registered factories.}
\item{\code{clearRegisteredFactories()}}{Remove all registered factories.
  Note that the factories are not deleted, just removed from the map.}
\item{\code{getModelFrame()}}{Get each target data matrix parsed to one
  big matrix.}
\item{\code{getNumberOfRegisteredFactories()}}{Get the number of registered
  factories.}
}
}

\examples{
# Sample data:
data.mat = cbind(1:10)

# Create new data object:
data.source = InMemoryData$new(data.mat, "my.data.name")
data.target1 = InMemoryData$new()
data.target2 = InMemoryData$new()

lin.factory = BaselearnerPolynomial$new(data.source, data.target1, 1, TRUE)
poly.factory = BaselearnerPolynomial$new(data.source, data.target2, 2, TRUE)

# Create new base-learner list:
my.bl.list = BlearnerFactoryList$new()

# Register factories:
my.bl.list$registerFactory(lin.factory)
my.bl.list$registerFactory(poly.factory)

# Get registered factories:
my.bl.list$printRegisteredFactories()

# Get all target data matrices in one big matrix:
my.bl.list$getModelFrame()

# Clear list:
my.bl.list$clearRegisteredFactories()

# Get number of registered factories:
my.bl.list$getNumberOfRegisteredFactories()

}
