% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hamming.R
\name{Hamming}
\alias{Hamming}
\title{Hamming String/Sequence Comparator}
\usage{
Hamming(
  normalize = FALSE,
  similarity = FALSE,
  ignore_case = FALSE,
  use_bytes = FALSE
)
}
\arguments{
\item{normalize}{a logical. If TRUE, distances/similarities are normalized
to the unit interval. Defaults to FALSE.}

\item{similarity}{a logical. If TRUE, similarity scores are returned
instead of distances. Defaults to FALSE.}

\item{ignore_case}{a logical. If TRUE, case is ignored when comparing
strings.}

\item{use_bytes}{a logical. If TRUE, strings are compared byte-by-byte
rather than character-by-character.}
}
\value{
A \code{Hamming} instance is returned, which is an S4 class inheriting from
\code{\linkS4class{StringComparator}}.
}
\description{
The Hamming distance between two strings/sequences of equal length is the
number of positions where the corresponding characters/sequence elements
differ. It can be viewed as a type of edit distance where the only
permitted operation is substitution of characters/sequence elements.
}
\details{
When the input strings/sequences \eqn{x} and \eqn{y} are of
different lengths (\eqn{|x| \neq |y|}{|x| != |y|}), the Hamming distance
is defined to be \eqn{\infty}{Inf}.

A Hamming similarity is returned if \code{similarity = TRUE}. When
\eqn{|x| = |y|} the similarity is defined as follows:
\deqn{\mathrm{sim}(x, y) = |x| - \mathrm{dist}(x, y),}{sim(x, y) = |x| - dist(x, y),}
where \eqn{sim} is the Hamming similarity and \eqn{dist} is the Hamming
distance. When \eqn{|x| \neq |y|}{|x| != |y|} the similarity is defined to
be 0.

Normalization of the Hamming distance/similarity to the unit interval is
also supported by setting \code{normalize = TRUE}. The raw distance/similarity
is divided by the length of the string/sequence \eqn{|x| = |y|}. If
\eqn{|x| \neq |y|}{|x| != |y|} the normalized distance is defined to be 1,
while the normalized similarity is defined to be 0.
}
\note{
While the unnormalized Hamming distance is a metric, the normalized
variant is not as it does not satisfy the triangle inequality.
}
\examples{
## Compare US ZIP codes
x <- "90001"
y <- "90209"
m1 <- Hamming()                                     # unnormalized distance
m2 <- Hamming(similarity = TRUE, normalize = TRUE)  # normalized similarity
m1(x, y)
m2(x, y)

}
\seealso{
Other edit-based comparators include \code{\link{LCS}}, \code{\link{Levenshtein}},
\code{\link{OSA}} and \code{\link{DamerauLevenshtein}}.
}
