% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wgcm.R
\name{wgcm}
\alias{wgcm}
\title{Weighted Generalised covariance measure test}
\usage{
wgcm(
  Y,
  X,
  Z,
  reg_YonZ = "rf",
  reg_XonZ = "rf",
  reg_wfun = "rf",
  args_XonZ = NULL,
  args_wfun = NULL,
  frac = 0.5,
  B = 499L,
  coin = TRUE,
  cointrol = NULL,
  return_fitted_models = FALSE,
  ...
)
}
\arguments{
\item{Y}{Vector of response values. Can be supplied as a numeric vector or
a single column matrix.}

\item{X}{Matrix or data.frame of covariates.}

\item{Z}{Matrix or data.frame of covariates.}

\item{reg_YonZ}{Character string or function specifying the regression for
Y on Z. See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_XonZ}{Character string or function specifying the regression for
X on Z. See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_wfun}{Character string or function specifying the regression for
estimating the weighting function.
See \code{?\link[comets]{regressions}} for more detail.}

\item{args_XonZ}{A list of named arguments passed to \code{reg_XonZ}.}

\item{args_wfun}{Additional arguments passed to \code{reg_XonZ}.}

\item{frac}{Relative size of train split.}

\item{B}{Number of bootstrap samples. Only applies if \code{type = "max"} is
used.}

\item{coin}{Logical; whether or not to use the \code{coin} package for
computing the test statistic and p-value. The \code{coin} package
computes variances with n - 1 degrees of freedom.
The default is \code{TRUE}.}

\item{cointrol}{List; further arguments passed to
\code{\link[coin]{independence_test}}.}

\item{return_fitted_models}{Logical; whether to return the fitted regressions
(default is \code{FALSE}).}

\item{...}{Additional arguments passed to \code{reg_YonZ}.}
}
\value{
Object of class '\code{wgcm}' and '\code{htest}' with the following
components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{p.value}}{The p-value for the \code{hypothesis}}
\item{\code{parameter}}{In case X is multidimensional, this is the degrees of
    freedom used for the chi-squared test.}
\item{\code{hypothesis}}{String specifying the null hypothesis .}
\item{\code{null.value}}{String specifying the null hypothesis.}
\item{\code{method}}{The string \code{"Generalised covariance measure test"}.}
\item{\code{data.name}}{A character string giving the name(s) of the data.}
\item{\code{rY}}{Residuals for the Y on Z regression.}
\item{\code{rX}}{Weighted residuals for the X on Z regression.}
\item{\code{W}}{Estimated weights.}
\item{\code{models}}{List of fitted regressions if \code{return_fitted_models} is \code{TRUE}.}
}
\description{
Weighted Generalised covariance measure test
}
\details{
The weighted generalised covariance measure test tests whether a weighted
version of the conditional covariance of Y and X given Z is zero.
}
\examples{
n <- 100
X <- matrix(rnorm(2 * n), ncol = 2)
colnames(X) <- c("X1", "X2")
Z <- matrix(rnorm(2 * n), ncol = 2)
colnames(Z) <- c("Z1", "Z2")
Y <- X[, 2]^2 + Z[, 2] + rnorm(n)
(wgcm1 <- wgcm(Y, X, Z))

}
\references{
Scheidegger, C., Hörrmann, J., & Bühlmann, P. (2022). The weighted
generalised covariance measure. Journal of Machine Learning Research,
23(273), 1-68.
}
