% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coma.R
\name{get_coma}
\alias{get_coma}
\title{Create a co-occurrence matrix (coma)}
\usage{
get_coma(x, neighbourhood = 4, classes = NULL)
}
\arguments{
\item{x}{A matrix with categories}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{classes}{A vector or a list with the values of selected classes from the \code{x} object.
It is used to calculate coma only for selected classes.}
}
\value{
A co-occurrence matrix
}
\description{
Create a co-occurrence matrix (coma)
}
\examples{
#library(comat)
data(raster_x, package = "comat")

com = get_coma(raster_x)
com

com2 = get_coma(raster_x, classes = c(1, 3))
com2

data(raster_x_na, package = "comat")
com3 = get_coma(raster_x_na, classes = c(0:3, NA))
com3
}
