% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{average_clusters_rowwise}
\alias{average_clusters_rowwise}
\title{Rowwise math from matrix/data.frame per cluster based on another vector/metadata,
similar to clustifyr::average_clusters but ids as rows}
\usage{
average_clusters_rowwise(
  mat,
  metadata,
  cluster_col = "cluster",
  if_log = FALSE,
  cell_col = NULL,
  low_threshold = 0,
  method = "mean",
  output_log = FALSE,
  cut_n = NULL,
  trim = FALSE
)
}
\arguments{
\item{mat}{expression matrix}

\item{metadata}{data.frame or vector containing cluster assignments per cell.
Order must match column order in supplied matrix. If a data.frame
provide the cluster_col parameters.}

\item{cluster_col}{column in metadata with cluster number}

\item{if_log}{input data is natural log,
averaging will be done on unlogged data}

\item{cell_col}{if provided, will reorder matrix first}

\item{low_threshold}{option to remove clusters with too few cells}

\item{method}{whether to take mean (default), median, 10\% truncated mean, or trimean,
max, min, sum}

\item{output_log}{whether to report log results}

\item{cut_n}{set on a limit of genes as expressed, lower ranked genes
are set to 0, considered unexpressed}

\item{trim}{whether to remove 1 percentile when doing min caluculation}
}
\value{
average expression matrix, with genes for row names, and clusters
for column names
}
\description{
Rowwise math from matrix/data.frame per cluster based on another vector/metadata,
similar to clustifyr::average_clusters but ids as rows
}
\examples{
mat <- average_clusters_rowwise(data.frame(
  y = c(1, 2, 3, 4, 5, 6),
  x = c(1, 2, 3, 4, 5, 6)
), metadata = c(1, 2, 1, 2, 1, 2), method = "min")
}
