% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_response}
\alias{validate_response}
\title{Validate the 'response' argument for target encoding of non-numeric variables}
\usage{
validate_response(df = NULL, response = NULL, decimals = 4)
}
\arguments{
\item{df}{(required; data frame) A validated data frame with numeric and/or character predictors predictors, and optionally, a response variable. Default: NULL.}

\item{response}{(optional, character string) Name of a numeric response variable. Character response variables are ignored. Default: NULL.}

\item{decimals}{(required, integer) number of decimal places for the zero variance test. Default: 4}
}
\value{
character string with name of the response
}
\description{
Requires the argument 'df' to be validated with \code{\link[=validate_df]{validate_df()}}.
}
\examples{

data(
  vi
)

#validating example data frame
vi <- validate_df(
  df = vi
)

#validating example predictors
response <- validate_response(
  df = vi,
  response = "vi_mean"
)

#tagged as validated
attributes(response)$validated

}
\author{
Blas M. Benito
}
