% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{combine_norm}
\alias{combine_norm}
\title{Weight a set of normal parameters into a single distribution}
\usage{
combine_norm(dat)
}
\arguments{
\item{dat}{Dataframe of mean, sd and weights.}
}
\value{
A dataframe.
}
\description{
Given a set of arbitrary parameters that includes at least a weight column,
take a weighted average of all the other parameters.
}
\examples{
dat <- data.frame(mean = c(10, 20, 30),
              sd = c(4, 5, 10),
              weight = c(2, 1, 2))
combine_norm(dat)
}
\seealso{
Other distribution fitting functions: \code{\link{combine_lognorm_trunc}},
  \code{\link{combine_lognorm}},
  \code{\link{fit_capabilities_geomean}},
  \code{\link{fit_capabilities}},
  \code{\link{fit_lognorm_trunc}},
  \code{\link{fit_lognorm}}, \code{\link{fit_norm_trunc}},
  \code{\link{fit_pois}},
  \code{\link{fit_scenarios_geomean}},
  \code{\link{fit_scenarios}},
  \code{\link{fit_threat_communities}},
  \code{\link{generate_cost_function}},
  \code{\link{lognormal_to_normal}},
  \code{\link{normal_to_lognormal}}
}
\concept{distribution fitting functions}
