% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fill_zeros}
\alias{fill_zeros}
\title{Add zero abundances for missing species, on the assumption that any species
in the \code{species.var} column should be included for every group defined
by all the remaining columns save \code{abundance.var}.}
\usage{
fill_zeros(df, species.var, abundance.var)
}
\arguments{
\item{df}{A dataframe with species, abundances, and at least one other column
to group by}

\item{species.var}{The name of the species column from df}

\item{abundance.var}{The name of the abundance column from df}
}
\value{
A dataframe with the same columns as df, but with zeros added for
  species that are present in df, but not in a particular group.
}
\description{
Add zero abundances for missing species, on the assumption that any species
in the \code{species.var} column should be included for every group defined
by all the remaining columns save \code{abundance.var}.
}
