% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_all_phases}
\alias{get_all_phases}
\title{Obtain a list of all phases of a bullet-by-bullet comparison}
\usage{
get_all_phases(land1, land2, score, addNA = FALSE)
}
\arguments{
\item{land1}{(numeric) vector with land ids of bullet 1}

\item{land2}{(numeric) vector with land ids of bullet 2}

\item{score}{numeric vector of scores to be summarized into a single number}

\item{addNA}{logical value. In case of missing lands, are scores set to 0 (addNA = FALSE) or set to NA (addNA = TRUE)}
}
\value{
a list of all phases
}
\description{
Obtain a list of all phases of a bullet-by-bullet comparison
}
\examples{
library(tidyverse)

data("bullets")

lands <- unique(bullets$bulletland)

comparisons <- data.frame(expand.grid(land1 = lands[1:6], land2 = lands[7:12]),
                          stringsAsFactors = FALSE)

comparisons <- comparisons \%>\%
  left_join(bullets \%>\% select(bulletland, sig1=sigs),
            by = c("land1" = "bulletland")) \%>\%
  left_join(bullets \%>\% select(bulletland, sig2=sigs),
            by = c("land2" = "bulletland"))

comparisons <- comparisons \%>\% mutate(
  cmps = purrr::map2(sig1, sig2, .f = function(x, y) {
    extract_feature_cmps(x$sig, y$sig, include = "full_result")
  })
)

comparisons <- comparisons \%>\%
  mutate(
    cmps_score = sapply(comparisons$cmps, function(x) x$CMPS.score),
    cmps_nseg = sapply(comparisons$cmps, function(x) x$nseg)
  )
  
cp1 <- comparisons \%>\% select(land1, land2, cmps_score, cmps_nseg)
cp1 <- cp1 \%>\% mutate(
  land1idx = land1 \%>\% str_sub(-1, -1) \%>\% as.numeric(),
  land2idx = land2 \%>\% str_sub(-1, -1) \%>\% as.numeric()
)

with(cp1, {
  get_all_phases(land1idx, land2idx, cmps_score, addNA = TRUE)
})
}
