% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conceptMapping.R
\name{conceptMapping}
\alias{conceptMapping}
\title{Perform Concept Mapping Analysis}
\usage{
conceptMapping(
  CMData,
  method = "network",
  numberOfClusters = "auto",
  verbose = TRUE,
  rangeNumberOfClusters = 2:15,
  graph = FALSE,
  numberOfKmeansRestarts = 100,
  backgroundColor = "black",
  main = NULL,
  ...
)
}
\arguments{
\item{CMData}{A data frame containing concept mapping data.
It must include the columns:
\code{"sorterID"}, \code{"statement"}, and \code{"stackID"}.}

\item{method}{A string specifying the clustering method to use. Options are:
\code{"kmeans"}, \cr \code{"network"}, or \code{"cmds"}. Default is \code{"network"}.}

\item{numberOfClusters}{Either a character string (\code{"auto"}) to determine the optimal number of clusters
or an integer specifying the desired number of clusters. Default is \code{"auto"}.}

\item{verbose}{Logical, if \code{TRUE}, additional information about the processing steps is printed to the console.}

\item{rangeNumberOfClusters}{A vector of integers specifying the range of clusters to evaluate
when \cr \code{numberOfClusters = "auto"}. Default is \code{2:15}.}

\item{graph}{Logical. If \code{TRUE}, visualizes clustering results, including heatmaps and cluster-specific plots.
Default is \code{FALSE}.}

\item{numberOfKmeansRestarts}{An integer specifying the number of restarts for k-means clustering.
Only relevant if \code{method = "kmeans"}. Default is \code{100}.}

\item{backgroundColor}{A string specifying the background color of network plots. Default is \code{"black"}.}

\item{main}{A string specifying the title for plots. Default is \code{NULL}.}

\item{...}{Additional arguments, such as \code{resolution}, which may be passed to specific clustering methods.}
}
\value{
An object of class \code{conceptMap}, containing:
\describe{
\item{\code{allStatements}}{A data frame with statement numbers and text.}
\item{\code{CMData}}{The original concept mapping data.}
\item{\code{method}}{The clustering method used.}
\item{\code{numberOfClusters}}{The number of clusters identified.}
\item{\code{clusterResults}}{A vector indicating cluster assignments for each statement.}
\item{\code{heatmapPlot}}{A heatmap visualizing co-occurrence patterns.}
\item{\code{silhouettePlot}}{(If applicable) A silhouette plot for \code{"kmeans"} or \code{"cmds"}.}
\item{\code{networkPlot}}{(If applicable) A network plot for \code{"network"}.}
\item{\code{cmdsPlot}}{(If applicable) A CMDS plot for \code{"cmds"}.}
}
}
\description{
This function conducts a concept mapping analysis on sorter data, producing a concept map
based on one of three clustering methods: k-means, network analysis, or classical multidimensional scaling (CMDS).
}
\details{
The function supports three methods for clustering:
\itemize{
\item \code{"kmeans"}: Uses k-means clustering with an optional silhouette-based determination of cluster count.
\item \code{"network"}: Generates a network plot using modularity-based clustering.
\item \code{"cmds"}: Applies classical multidimensional scaling (CMDS) and clusters the results.
}

Heatmaps are created for all methods, while additional visualizations depend on the chosen method and \code{graph} parameter.
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Concept mapping on sorter cluster 3 using default "network" method
myCMAnalysis3 <- conceptMapping(myCMDataBySorters[[3]])

# Concept mapping using default network method using 3 clusters
myCMAnalysis3b <- conceptMapping(myCMDataBySorters[[3]], numberOfCluster = 3)

# Concept mapping using kmeans clustering and 3 clusters
myCMAnalysis3c <- conceptMapping(myCMDataBySorters[[3]], method = "kmeans",
  numberOfCluster = 3)




}
