% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusternor.R
\name{FuzzyCMeans}
\alias{FuzzyCMeans}
\title{Perform Fuzzy C-means clustering on a data matrix.
A soft variant of the kmeans algorithm where each data point are assigned a
 contribution weight to each cluster}
\usage{
FuzzyCMeans(
  data,
  centers,
  nrow = -1,
  ncol = -1,
  iter.max = .Machine$integer.max,
  nthread = -1,
  fuzz.index = 2,
  init = c("forgy", "none"),
  tolerance = 1e-06,
  dist.type = c("sqeucl", "eucl", "cos", "taxi")
)
}
\arguments{
\item{data}{Data file name on disk (NUMA optimized) or In memory data matrix}

\item{centers}{Either (i) The number of centers (i.e., k), or
(ii) an In-memory data matrix}

\item{nrow}{The number of samples in the dataset}

\item{ncol}{The number of features in the dataset}

\item{iter.max}{The maximum number of iteration of k-means to perform}

\item{nthread}{The number of parallel threads to run}

\item{fuzz.index}{The fuzziness coefficient/index (> 1 and < inf)}

\item{init}{The type of initialization to use c("forgy", "none")}

\item{tolerance}{The convergence tolerance}

\item{dist.type}{What dissimilarity metric to use}
}
\value{
A list containing the attributes of the output.
 cluster: A vector of integers (from 1:\strong{k}) indicating the cluster to
         which each point is allocated.
 centers: A matrix of cluster centres.
 size: The number of points in each cluster.
 iter: The number of (outer) iterations.
 contrib.mat: The data point to cluster contribution matrix
}
\description{
See: https://en.wikipedia.org/wiki/Fuzzy_clustering#Fuzzy_C-means_clustering
}
\examples{
iris.mat <- as.matrix(iris[,1:4])
k <- length(unique(iris[, dim(iris)[2]])) # Number of unique classes
fcm <- FuzzyCMeans(iris.mat, k, iter.max=5)

}
\author{
Disa Mhembere <disa@cs.jhu.edu>
}
