% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_transfer.R
\name{cloud_drive_write}
\alias{cloud_drive_write}
\title{Write an object to Google Drive}
\usage{
cloud_drive_write(x, file, fun = NULL, ..., local = FALSE, root = NULL)
}
\arguments{
\item{x}{An R object to be written to Google Drive.}

\item{file}{Path to a file relative to project folder root. Can contain only
letters, digits, '-', '_', '.', spaces and '/' symbols.}

\item{fun}{A custom writing function. If \code{NULL} (default), the appropriate
writing function will be inferred based on the file's extension.}

\item{...}{Additional arguments to pass to the writing function \code{fun}.}

\item{local}{Logical. If \code{TRUE}, a local copy of the file will also be
created at the specified path. Default is \code{FALSE}.}

\item{root}{Google Drive ID or URL of the project root. This serves as the
reference point for all relative paths. When left as \code{NULL}, the root is
automatically derived from the \code{cloudfs.drive} field of the project's
DESCRIPTION file.}
}
\value{
Invisibly returns a \link[googledrive:dribble]{googledrive::dribble} object representing the
written file on Google Drive.
}
\description{
Saves an R object to a designated location in the project's
Google Drive folder. If no custom writing function is provided, the
function will infer the appropriate writing method based on the file's
extension.
}
\section{Default writing functions}{


Here's how we identify a writing function based on file extension
\itemize{
\item \code{.csv}: \link[readr:write_delim]{readr::write_csv}
\item \code{.json}: \link[jsonlite:read_json]{jsonlite::write_json}
\item \code{.rds}: \link[base:readRDS]{base::saveRDS}
\item \code{.xls}: \link[writexl:write_xlsx]{writexl::write_xlsx}
\item \code{.xlsx}: \link[writexl:write_xlsx]{writexl::write_xlsx}
\item \code{.sav}: \link[haven:read_spss]{haven::write_sav}
\item \code{.xml}: \link[xml2:write_xml]{xml2::write_xml}
}
}

\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# write mtcars dataframe to mtcars.csv in data folder
cloud_drive_write(mtcars, "data/mtcars.csv")
cloud_drive_write(random_forest, "models/random_forest.rds")

# provide custom writing function with parameters 
cloud_drive_write(c("one", "two"), "text/count.txt", writeLines, sep = "\n\n")
\dontshow{\}) # examplesIf}
}
