% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_setup.R
\name{cloud_drive_find_path}
\alias{cloud_drive_find_path}
\title{Find Google Drive folder based on a path}
\usage{
cloud_drive_find_path(root, path = "", create = FALSE)
}
\arguments{
\item{root}{ID of the folder to start search at.}

\item{path}{Relative location with respect to the root folder.}

\item{create}{Create folders describing path if they do not exist? Default is
\code{FALSE} so by default the function throws an error if path was not found.
If \code{TRUE}, the function will create all missing subdirectories. Note that
the object on the deepest level will always be created as a folder. E.g.
if \code{path = "models/kmeans/model.Rds"} and \code{"model.Rds"} is missing, this
function will create a folder with such name.}
}
\value{
A \link[googledrive:dribble]{googledrive::dribble} object corresponding to the folder.
}
\description{
Given a Google Drive id pointing to a folder and a relative path
inside this folder, returns id of the object (file or folder) corresponding
to this path.
}
\details{
Google Drive file structure is different from the usual file
structure like e.g. on Linux or Windows. A folder on Google Drive can have
two or more child folders with the same name. Google Drive marks files and
folders with so-called id values to distinguish between them. These values
are always unique. You can see them in browser URL for example. The concept
of "name" is in the first place for convenience of the end user.

In such a setup a relative file path may correspond to multiple files or
folders. This function however works under assumption that the relative
path you pass to it defines strictly one object. If there's any ambiguity
it throws an error.
}
\keyword{internal}
