/*
 * Decompiled with CFR 0.152.
 */
package nbl.utilj;

import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GuiMetrics {
    public static int STANDARD_SPACE = 5;
    public static int screenWidth;
    public static int screenHeight;
    public static FontMetrics fontMetrics;
    public static int widthX;
    public static int lineHeight;
    public static JLabel LABEL_SAMPLE;
    public static boolean permitInit;
    private static boolean isInitialized;

    public static void init() {
        if (!permitInit) {
            return;
        }
        if (isInitialized) {
            return;
        }
        LABEL_SAMPLE = new JLabel("Abc");
        screenWidth = GuiMetrics.getScreenWidth();
        screenHeight = GuiMetrics.getScreenHeight();
        fontMetrics = LABEL_SAMPLE.getFontMetrics(LABEL_SAMPLE.getFont());
        widthX = fontMetrics.charWidth('X');
        lineHeight = fontMetrics.getHeight();
        isInitialized = true;
    }

    public static int getScreenWidth(JComponent c) {
        return GuiMetrics.getScreenSize((JComponent)c).width;
    }

    public static int getScreenWidth() {
        return GuiMetrics.getScreenWidth(LABEL_SAMPLE);
    }

    public static int getScreenHeight(JComponent c) {
        return GuiMetrics.getScreenSize((JComponent)c).height;
    }

    public static int getScreenHeight() {
        return GuiMetrics.getScreenHeight(LABEL_SAMPLE);
    }

    public static Dimension getScreenSize(JComponent c) {
        try {
            return c.getToolkit().getScreenSize();
        }
        catch (NullPointerException xxx) {
            System.err.println("c == null? " + (c == null));
            throw xxx;
        }
    }

    public static Dimension getScreenSize() {
        return GuiMetrics.getScreenSize(LABEL_SAMPLE);
    }

    public static Dimension noBiggerThanScreen(Dimension d) {
        return new Dimension(Math.min(d.width, screenWidth), Math.min(d.height, screenHeight));
    }

    public static Dimension noBiggerThanScreenFraction(Dimension d, float fraction) {
        return new Dimension(Math.min(d.width, GuiMetrics.roundMult(screenWidth, fraction)), Math.min(d.height, GuiMetrics.roundMult(screenHeight, fraction)));
    }

    public static int roundMult(int v, float factor) {
        return Math.round((float)v * factor);
    }

    public static Dimension screenFraction(float fraction) {
        return new Dimension(Math.max(GuiMetrics.roundMult(screenWidth, fraction), 1), Math.max(GuiMetrics.roundMult(screenHeight, fraction), 1));
    }

    public static int toPixelWidth(float fraction) {
        return GuiMetrics.roundMult(screenWidth, fraction);
    }

    public static int toPixelHeight(float fraction) {
        return GuiMetrics.roundMult(screenHeight, fraction);
    }

    public static int roundDiv(int numer, int denom) {
        return Math.round((float)numer / (float)denom);
    }

    public static int getWidth(String s) {
        return fontMetrics.stringWidth(s);
    }

    public static int upToMultiple(int h, int lineH) {
        if (h % lineH == 0) {
            return h;
        }
        return (int)Math.ceil((double)h / (double)lineH) * lineH;
    }

    static {
        permitInit = true;
        isInitialized = false;
    }
}

