/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util;

import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.FileUtil;
import com.norbl.util.InaccessibleFileException;
import com.norbl.util.SysProp;
import com.norbl.util.gui.GuiUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ParamHt
extends HashMap<String, String> {
    public File configFile;
    public String configFilenameDefault;
    private static HashMap<String, String> epHt = new HashMap();

    public ParamHt(String[] argv, String configFilenameDefault) throws InaccessibleFileException, IOException {
        this.configFilenameDefault = configFilenameDefault;
        String configFilePath = ParamHt.getDefaultConfigFilePath(configFilenameDefault);
        this.setConfigFile(configFilePath);
        String configFilename = this.getVal(argv, ParamName.configFile);
        if (configFilename != null) {
            this.setConfigFile(configFilename);
        }
        if (this.configFile != null && this.configFile.exists()) {
            this.recordParams(this.getParamsFromConfigFile());
        }
        if (argv != null && argv.length > 0) {
            this.recordParams(argv);
        }
    }

    public boolean reloadParams() {
        try {
            if (this.configFile != null && this.configFile.exists()) {
                this.recordParams(this.getParamsFromConfigFile());
                return true;
            }
            return false;
        }
        catch (Exception x) {
            GuiUtil.exceptionMessage(x);
            return false;
        }
    }

    public static String getDefaultConfigFilePath(String configFilename) {
        return SysProp.user_home.getVal() + "/" + configFilename;
    }

    private String getVal(String[] argv, ParamName par) {
        String ps = par.toString().toLowerCase() + "=";
        for (String arg : argv) {
            String[] a;
            if (!arg.toLowerCase().startsWith(ps) || (a = arg.split("=")) == null && a.length != 2) continue;
            return a[1];
        }
        return null;
    }

    private void setConfigFile(String path) throws InaccessibleFileException {
        File f = new File(path);
        if (f.exists() && !f.isDirectory()) {
            if (f.canRead()) {
                this.configFile = f;
            } else {
                throw new InaccessibleFileException("The config file " + f.getPath() + " exists but is not readable by this application.");
            }
        }
    }

    private String[] getParamsFromConfigFile() throws IOException {
        BufferedReader buffy = new BufferedReader(new FileReader(this.configFile));
        ArrayList<String> lst = new ArrayList<String>();
        String ln = null;
        while ((ln = buffy.readLine()) != null) {
            String pair = ln.trim();
            if (pair.startsWith("#") || !pair.contains("=")) continue;
            lst.add(pair);
        }
        return lst.toArray(new String[lst.size()]);
    }

    void recordParams(String[] argv) {
        if (argv == null) {
            return;
        }
        for (String arg : argv) {
            String[] a = arg.split("=");
            if (a == null || a.length != 2) continue;
            this.put(this.encase(a[0]), a[1]);
        }
    }

    public void writeToConfigFile() {
        this.writeToConfigFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToConfigFile(boolean showFileWrit) {
        BufferedWriter b = null;
        try {
            File backupFile = null;
            File cf = null;
            if (this.configFile == null) {
                this.configFile = new File(ParamHt.getDefaultConfigFilePath(this.configFilenameDefault));
            }
            if ((cf = new File(this.configFile.getPath())).exists() && !cf.renameTo(backupFile = FileUtil.getBackupFilename(cf))) {
                GuiUtil.warning(new String[]{"Unable to rename " + cf.getPath() + "; changes were not saved."}, "File rename error");
                return;
            }
            b = new BufferedWriter(new FileWriter(this.configFile));
            for (String key : this.keySet()) {
                String val = (String)this.get(key);
                if (val == null) continue;
                b.write(key + "=" + val + "\n");
            }
            b.flush();
            if (showFileWrit) {
                GuiUtil.info(new String[]{"Wrote params to config file " + this.configFile.getPath(), backupFile != null ? "The old version was saved as " + backupFile.getPath() : ""}, "Updated config file");
            }
        }
        catch (IOException iox) {
            GuiUtil.exceptionMessage(iox);
        }
        finally {
            if (b != null) {
                try {
                    b.flush();
                    b.close();
                }
                catch (IOException ox) {
                    GuiUtil.exceptionMessage(ox);
                }
            }
        }
    }

    public void saveAndReload(boolean showFileWrit) {
        this.writeToConfigFile(showFileWrit);
        this.reloadParams();
    }

    public void saveAndReload() {
        this.saveAndReload(true);
    }

    public void show() {
        for (String k : this.keySet()) {
            System.out.println(k + "=" + (String)this.get(k));
        }
    }

    private String encase(String key) {
        if (epHt.containsKey(key.toLowerCase())) {
            return epHt.get(key.toLowerCase());
        }
        return key;
    }

    static {
        for (ParamsEc2.ParamName pn : ParamsEc2.ParamName.values()) {
            epHt.put(pn.toString().toLowerCase(), pn.toString());
        }
    }

    public static enum ParamName {
        configFile;

    }
}

