/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Region;
import java.util.ArrayList;
import java.util.List;

public class AmiDescription {
    public static Image getImageInfo(AmazonEC2Client ec2Client, String amiID) {
        ArrayList<String> IDs = new ArrayList<String>();
        IDs.add(amiID);
        DescribeImagesRequest req = new DescribeImagesRequest();
        req.setImageIds(IDs);
        List imgs = ec2Client.describeImages(req).getImages();
        for (Image img : imgs) {
            if (!img.getImageId().equals(amiID)) continue;
            return img;
        }
        return null;
    }

    public static List<AvailabilityZone> getAvailabilityZones(AmazonEC2Client ec2Client, Region region) {
        ec2Client.setEndpoint(region.getEndpoint());
        return ec2Client.describeAvailabilityZones().getAvailabilityZones();
    }

    public static List<AvailabilityZone> getAvailabilityZones(AmazonEC2Client ec2Client, String amiID) {
        Region region = AmiDescription.getRegion(ec2Client, amiID);
        if (region == null) {
            return new ArrayList<AvailabilityZone>();
        }
        return AmiDescription.getAvailabilityZones(ec2Client, region);
    }

    public static Region getRegion(AmazonEC2Client ec2Client, String amiID) {
        DescribeRegionsResult rr = ec2Client.describeRegions();
        for (Region reg : rr.getRegions()) {
            ec2Client.setEndpoint(reg.getEndpoint());
            if (!AmiDescription.hasAmi(ec2Client, amiID)) continue;
            return reg;
        }
        ec2Client.setEndpoint("ec2.amazonaws.com");
        return null;
    }

    public static AvailabilityZone getAvailabilityZone(AmazonEC2Client ec2Client, String zoneName) {
        DescribeAvailabilityZonesResult r = ec2Client.describeAvailabilityZones();
        for (AvailabilityZone z : r.getAvailabilityZones()) {
            if (!z.getZoneName().equals(zoneName)) continue;
            return z;
        }
        return null;
    }

    public static boolean isSpecifiedValidAvailabilityZone(AmazonEC2Client ec2Client, String zoneName) {
        if (zoneName == null) {
            return false;
        }
        if (zoneName.equals("Use any zone.")) {
            return false;
        }
        return AmiDescription.getAvailabilityZone(ec2Client, zoneName) != null;
    }

    public static boolean hasAmi(AmazonEC2Client ec2Client, String amiID) {
        try {
            DescribeImagesRequest q = new DescribeImagesRequest();
            ArrayList<String> amis = new ArrayList<String>();
            amis.add(amiID);
            q = q.withImageIds(amis);
            DescribeImagesResult r = ec2Client.describeImages(q);
            return r.getImages().size() > 0;
        }
        catch (AmazonServiceException xxx) {
            return false;
        }
    }

    public static boolean isParavirtual(Image img) {
        return img.getVirtualizationType().equals("paravirtual");
    }

    public static boolean isHvm(Image img) {
        return img.getVirtualizationType().equals("hvm");
    }
}

