/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreatePlacementGroupRequest;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DeletePlacementGroupRequest;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PlacementGroup;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.IncompatibleInstanceImageException;
import com.norbl.cbp.ppe.IncompleteNetworkSpecException;
import com.norbl.cbp.ppe.InstanceStatus;
import com.norbl.cbp.ppe.InstanceTag;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.NoSuchAmiException;
import com.norbl.cbp.ppe.NoSuchInstanceException;
import com.norbl.cbp.ppe.NoSuchNetworkException;
import com.norbl.cbp.ppe.NodeType;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.SecurityGroupFactory;
import com.norbl.cbp.ppe.UtilEc2;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.ImproperParamException;
import com.norbl.util.MissingParamsException;
import com.norbl.util.StringUtil;
import com.norbl.util.aws.Ec2Location;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class Ec2Wrangler {
    private ParamsEc2 params;
    public AmazonEC2Client ec2Client;
    private SecurityGroupFactory sgFactory;

    public Ec2Wrangler(ParamsEc2 params, ClientConfiguration cc) throws MissingParamsException {
        this.params = params;
        this.ec2Client = cc == null ? new AmazonEC2Client(params.buildAWSCredentials()) : new AmazonEC2Client(params.buildAWSCredentials(), cc);
        this.sgFactory = new SecurityGroupFactory(params, this.ec2Client);
    }

    public ParamsEc2 getParams() {
        return this.params;
    }

    public void setParams(ParamsEc2 params) {
        this.params = params;
    }

    public String createNetwork(NetworkSpec spec, List<Ec2InstanceType> eits) throws IOException, MissingParamsException, ImproperParamException, IncompatibleInstanceImageException, NoSuchAmiException, NoSuchInstanceException, IncompleteNetworkSpecException, NoSuchNetworkException {
        if (!spec.isComplete()) {
            throw new IncompleteNetworkSpecException(spec.listMissingParams());
        }
        UtilEc2.checkInstanceImageCompatibility(eits, spec.instanceType, spec.imageID, this.ec2Client);
        String networkID = !spec.useSpotInstances ? this.launchInstances(spec) : this.launchSpotInstances(spec);
        NetworkInfo ni = NiM.getForIDWhenAvailable(networkID, ConstantsEc2.MAX_WAIT_FOR_NEW_NETWORK_INFO);
        this.waitForInstances(ni, spec.nInstances);
        NiM.update(this);
        return networkID;
    }

    public String launchInstances(InstanceType instanceType, String imageID, String availabilityZone, int minInstances, int maxInstances, String keyName, String securityGroupName, String networkName, String userData) throws MissingParamsException, ImproperParamException {
        if (minInstances < 1 || maxInstances < minInstances) {
            throw new ImproperParamException("instances min=" + minInstances + " max=" + maxInstances);
        }
        RunInstancesRequest req = new RunInstancesRequest();
        req.setInstanceType(instanceType);
        req.setImageId(imageID);
        if (Ec2Location.isValidAvailablityZone(this.ec2Client, availabilityZone)) {
            this.setAvailabilityZone(req, availabilityZone);
        }
        req.setMinCount(Integer.valueOf(minInstances));
        req.setMaxCount(Integer.valueOf(maxInstances));
        req.setKeyName(keyName);
        ArrayList<String> sgs = new ArrayList<String>();
        sgs.add(securityGroupName);
        req.setSecurityGroups(sgs);
        req.setUserData(Base64.encodeBase64String((byte[])userData.getBytes()));
        String networkID = NiM.createNetworkID();
        NetworkInfo ni = new NetworkInfo(networkID, networkName);
        NiM.register(ni);
        ni.setState(NetworkInfo.State.pending);
        if (this.isHVM(imageID)) {
            this.setupClusterPlacementGroup(req);
        }
        RunInstancesResult rr = this.ec2Client.runInstances(req);
        NiM.update(this);
        this.waitForAllInstancesToBeRunning(rr);
        this.tagInstances(Ec2Wrangler.getInstanceIDs(rr), networkID, networkName);
        NiM.update(this.getInstancesAllListed());
        return networkID;
    }

    private void setAvailabilityZone(RunInstancesRequest req, String zone) {
        try {
            Placement p = new Placement(zone);
            req.setPlacement(p);
        }
        catch (Exception xxx) {
            ExceptionHandler.display(xxx);
        }
    }

    private void setAvailabilityZone(LaunchSpecification spec, String zone) {
        try {
            SpotPlacement p = new SpotPlacement(zone);
            spec.setPlacement(p);
        }
        catch (Exception xxx) {
            ExceptionHandler.display(xxx);
        }
    }

    public String launchInstances(NetworkSpec spec) throws MissingParamsException, ImproperParamException {
        if (spec.securityGroupName == null) {
            spec.securityGroupName = this.sgFactory.createOneTimeSecurityGroup();
        }
        return this.launchInstances(spec.instanceType, spec.imageID, spec.availabilityZone, spec.nInstances, spec.nInstances, spec.keyName, spec.securityGroupName, spec.networkName, spec.userData);
    }

    public String launchSpotInstances(InstanceType instanceType, String imageID, String availabilityZone, int nInstances, String keyName, String securityGroupName, String networkName, String userData, double spotPrice) throws MissingParamsException, ImproperParamException {
        List<String> instanceIDs;
        LaunchSpecification spec = new LaunchSpecification();
        spec.setInstanceType(instanceType);
        spec.setImageId(imageID);
        if (Ec2Location.isValidAvailablityZone(this.ec2Client, availabilityZone)) {
            this.setAvailabilityZone(spec, availabilityZone);
        }
        spec.setKeyName(keyName);
        ArrayList<String> sgs = new ArrayList<String>();
        sgs.add(securityGroupName);
        spec.setSecurityGroups(sgs);
        spec.setUserData(userData);
        if (this.isHVM(imageID)) {
            this.setupClusterPlacementGroup(spec);
        }
        RequestSpotInstancesRequest reqSpot = new RequestSpotInstancesRequest();
        reqSpot.setInstanceCount(new Integer(nInstances));
        reqSpot.setSpotPrice(StringUtil.f2(spotPrice));
        reqSpot.setLaunchSpecification(spec);
        String networkID = NiM.createNetworkID();
        NetworkInfo ni = new NetworkInfo(networkID, networkName);
        NiM.register(ni);
        ni.setState(NetworkInfo.State.spotRequestPending);
        RequestSpotInstancesResult rr = this.ec2Client.requestSpotInstances(reqSpot);
        HashMap<String, String> sirHt = this.getSpotInstanceRequestIDs(rr);
        if (sirHt.size() != nInstances) {
            ExceptionHandler.gui(new RuntimeException("Spot ht.size=" + sirHt.size() + " nInstances=" + nInstances));
        }
        while ((instanceIDs = this.getIIDsForSpotRequest(sirHt)).size() < sirHt.size()) {
            try {
                Thread.sleep(ConstantsEc2.SPOT_STATE_NAP_TIME);
            }
            catch (InterruptedException ix) {}
        }
        ni.setState(NetworkInfo.State.pending);
        this.tagInstances(instanceIDs, networkID, networkName);
        NiM.update(this.getInstancesAllListed());
        return networkID;
    }

    public String launchSpotInstances(NetworkSpec spec) throws MissingParamsException, ImproperParamException {
        if (spec.securityGroupName == null) {
            spec.securityGroupName = this.sgFactory.createOneTimeSecurityGroup();
        }
        return this.launchSpotInstances(spec.instanceType, spec.imageID, spec.availabilityZone, spec.nInstances, spec.keyName, spec.securityGroupName, spec.networkName, spec.userData, spec.spotPrice);
    }

    public void waitForInstances(NetworkInfo ni, int nInstancesExpected) {
        while (!this.allRunning(this.getInstances(ni), nInstancesExpected)) {
            try {
                Thread.sleep(ConstantsEc2.SPOT_STATE_NAP_TIME);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void waitForAllInstancesToBeRunning(RunInstancesResult rr) {
        while (!this.allRunning(rr)) {
            try {
                Thread.sleep(ConstantsEc2.SPOT_STATE_NAP_TIME);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public List<InstanceStatus> getInstancesActive() {
        ArrayList<InstanceStatus> ins = new ArrayList<InstanceStatus>();
        DescribeInstancesResult r = this.ec2Client.describeInstances();
        for (Reservation res : r.getReservations()) {
            List sgns = res.getGroupNames();
            for (Instance in : res.getInstances()) {
                InstanceStatus s = new InstanceStatus(in, sgns);
                if (!s.isActive()) continue;
                ins.add(s);
            }
        }
        return ins;
    }

    public List<InstanceStatus> getInstancesAllListed() {
        ArrayList<InstanceStatus> ins = new ArrayList<InstanceStatus>();
        DescribeInstancesResult r = this.ec2Client.describeInstances();
        for (Reservation res : r.getReservations()) {
            List sgns = res.getGroupNames();
            for (Instance in : res.getInstances()) {
                InstanceStatus s = new InstanceStatus(in, sgns);
                ins.add(s);
            }
        }
        return ins;
    }

    public static List<InstanceStatus> getInstances(RunInstancesResult rir) {
        ArrayList<InstanceStatus> ins = new ArrayList<InstanceStatus>();
        Reservation r = rir.getReservation();
        for (Instance in : r.getInstances()) {
            InstanceStatus s = new InstanceStatus(in, r.getGroupNames());
            if (!s.isActive()) continue;
            ins.add(s);
        }
        return ins;
    }

    public static List<InstanceStatus> getRunningInstances(RunInstancesResult rir) {
        ArrayList<InstanceStatus> ins = new ArrayList<InstanceStatus>();
        Reservation r = rir.getReservation();
        for (Instance in : r.getInstances()) {
            InstanceStatus s = new InstanceStatus(in, r.getGroupNames());
            if (!s.isActive()) continue;
            ins.add(s);
        }
        return ins;
    }

    public static List<String> getInstanceIDs(RequestSpotInstancesResult rir) {
        ArrayList<String> IDs = new ArrayList<String>();
        for (SpotInstanceRequest sr : rir.getSpotInstanceRequests()) {
            IDs.add(sr.getInstanceId());
        }
        return IDs;
    }

    public static List<String> getInstanceIDs(RunInstancesResult rir) {
        ArrayList<String> IDs = new ArrayList<String>();
        for (Instance ins : rir.getReservation().getInstances()) {
            IDs.add(ins.getInstanceId());
        }
        return IDs;
    }

    public InstanceStatus getMaster(NetworkInfo ni) {
        List<InstanceStatus> lst = this.getInstances(ni);
        for (InstanceStatus ins : lst) {
            if (!ins.isMaster()) continue;
            return ins;
        }
        return null;
    }

    public List<InstanceStatus> getInstances(NetworkInfo ni) {
        ArrayList<InstanceStatus> statuses = new ArrayList<InstanceStatus>();
        DescribeInstancesResult ir = this.ec2Client.describeInstances();
        for (Reservation r : ir.getReservations()) {
            List sgns = r.getGroupNames();
            List insL = r.getInstances();
            for (Instance ins : insL) {
                InstanceStatus x = new InstanceStatus(ins, sgns);
                if (!x.hasNetworkID(ni.ID)) continue;
                statuses.add(x);
            }
        }
        return statuses;
    }

    private List<Instance> getAllUsersInstances() {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        DescribeInstancesResult ir = this.ec2Client.describeInstances();
        for (Reservation r : ir.getReservations()) {
            instances.addAll(r.getInstances());
        }
        return instances;
    }

    public List<InstanceStatus> getSlaves(NetworkInfo ni) {
        List<InstanceStatus> lst = this.getInstances(ni);
        ArrayList<InstanceStatus> slaves = new ArrayList<InstanceStatus>();
        for (InstanceStatus ins : lst) {
            if (!ins.isSlave()) continue;
            slaves.add(ins);
        }
        return slaves;
    }

    public List<String> getActiveNetworkNames() {
        ArrayList<String> networkNames = new ArrayList<String>();
        DescribeInstancesResult ir = this.ec2Client.describeInstances();
        for (Reservation r : ir.getReservations()) {
            List sgns = r.getGroupNames();
            List insL = r.getInstances();
            for (Instance ins : insL) {
                InstanceStatus x = new InstanceStatus(ins, sgns);
                if (!x.isActive() || networkNames.contains(x.getNetworkName())) continue;
                networkNames.add(x.getNetworkName());
            }
        }
        return networkNames;
    }

    public String getMasterPublicDns(NetworkInfo ni) {
        InstanceStatus m = this.getMaster(ni);
        if (m != null) {
            return m.getPublicDnsName();
        }
        return null;
    }

    public List<String> getSlavesPublicDns(NetworkInfo ni) {
        List<InstanceStatus> sL = this.getSlaves(ni);
        ArrayList<String> sds = new ArrayList<String>();
        for (InstanceStatus s : sL) {
            sds.add(s.getPublicDnsName());
        }
        return sds;
    }

    public List<String> getPublicDns(NetworkInfo ni) {
        List<InstanceStatus> sL = this.getInstances(ni);
        ArrayList<String> sds = new ArrayList<String>();
        for (InstanceStatus s : sL) {
            sds.add(s.getPublicDnsName());
        }
        return sds;
    }

    public TerminateInstancesResult terminateInstances(List<String> instanceIDs) {
        TerminateInstancesRequest term = new TerminateInstancesRequest(instanceIDs);
        TerminateInstancesResult r = this.ec2Client.terminateInstances(term);
        this.deleteClusterGroupIfNecessary();
        return r;
    }

    public TerminateInstancesResult terminateInstances(NetworkInfo ni) {
        List<String> iids = this.getInstanceIDsFor(ni);
        if (iids.size() < 1) {
            return null;
        }
        List<String> securityGroups = this.sgFactory.getOneTimeSecurityGroups(ni);
        TerminateInstancesResult r = this.terminateInstances(iids);
        for (String sg : securityGroups) {
            this.sgFactory.deleteOneTimeSecurityGroup(sg);
        }
        return r;
    }

    public List<String> getKeypairNames() {
        ArrayList<String> names = new ArrayList<String>();
        DescribeKeyPairsResult r = this.ec2Client.describeKeyPairs();
        for (KeyPairInfo kpi : r.getKeyPairs()) {
            String nm = kpi.getKeyName();
            if (nm == null) continue;
            names.add(nm);
        }
        return names;
    }

    public void rebootInstances(NetworkInfo ni) throws Exception {
        ni.setState(NetworkInfo.State.rebooting);
        List<String> iids = this.getInstanceIDsFor(ni);
        if (iids.size() < 1) {
            return;
        }
        this.rebootInstances(iids);
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ni.pingAllInstances();
        ni.setState(NetworkInfo.State.nil);
        ni.setState();
    }

    public void rebootInstances(List<String> instanceIDs) {
        RebootInstancesRequest rir = new RebootInstancesRequest(instanceIDs);
        this.ec2Client.rebootInstances(rir);
    }

    public static String chooseNetworkName(ParamsEc2 params) {
        if (params.networkName != null && !NiM.nameExists(params.networkName)) {
            return params.networkName;
        }
        return NiM.createUniqueDefaultNetworkName();
    }

    private void tagInstances(List<String> instanceIDs, String networkID, String networkName) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(InstanceTag.networkID.toString(), networkID));
        tags.add(new Tag(InstanceTag.networkName.toString(), networkName));
        CreateTagsRequest req = new CreateTagsRequest(instanceIDs, tags);
        this.ec2Client.createTags(req);
        String master = instanceIDs.get(0);
        ArrayList<String> slaves = new ArrayList<String>();
        for (int i = 1; i < instanceIDs.size(); ++i) {
            slaves.add(instanceIDs.get(i));
        }
        ArrayList<Tag> masterTag = new ArrayList<Tag>();
        masterTag.add(new Tag(InstanceTag.nodeType.toString(), NodeType.master.toString()));
        ArrayList<String> masterR = new ArrayList<String>();
        masterR.add(master);
        req = new CreateTagsRequest(masterR, masterTag);
        this.ec2Client.createTags(req);
        if (slaves.size() > 0) {
            ArrayList<Tag> slaveTag = new ArrayList<Tag>();
            slaveTag.add(new Tag(InstanceTag.nodeType.toString(), NodeType.slave.toString()));
            req = new CreateTagsRequest(slaves, slaveTag);
            this.ec2Client.createTags(req);
        }
    }

    public void setTags(String instanceID, String networkID, String networkName, NodeType nodeType) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(InstanceTag.networkID.toString(), networkID));
        tags.add(new Tag(InstanceTag.networkName.toString(), networkName));
        tags.add(new Tag(InstanceTag.nodeType.toString(), nodeType.toString()));
        ArrayList<String> instanceIDs = new ArrayList<String>();
        instanceIDs.add(instanceID);
        CreateTagsRequest req = new CreateTagsRequest(instanceIDs, tags);
        this.ec2Client.createTags(req);
    }

    private void throwMissingParamsEx(String name) throws MissingParamsException {
        System.err.println("Param " + name + " is " + this.params.getMissingParamMessage() + "\nParams:\n" + this.params.toString() + "\n");
        Thread.dumpStack();
        throw new MissingParamsException("Param " + name + " is " + this.params.getMissingParamMessage());
    }

    private List<String> getNetworkIDsForNetworkName(String networkName) {
        DescribeInstancesResult ir = this.ec2Client.describeInstances();
        ArrayList<String> IDs = new ArrayList<String>();
        for (Reservation r : ir.getReservations()) {
            List sgns = r.getGroupNames();
            List insL = r.getInstances();
            for (Instance ins : insL) {
                String nwi;
                InstanceStatus x = new InstanceStatus(ins, sgns);
                if (!x.isActive() || (nwi = x.getNetworkName()) == null || !nwi.equals(networkName)) continue;
                IDs.add(x.getNetworkID());
            }
        }
        return IDs;
    }

    private String getCurrentNetworkID(List<String> networkIDs) {
        if (networkIDs == null || networkIDs.size() < 1) {
            return null;
        }
        String curNetID = null;
        long curTm = -1000L;
        for (String netID : networkIDs) {
            long cur = this.getLongTime(netID);
            if (cur <= curTm) continue;
            curNetID = netID;
            curTm = cur;
        }
        return curNetID;
    }

    private String getCurrentNetworkIDForNetworkName(String networkName) {
        return this.getCurrentNetworkID(this.getNetworkIDsForNetworkName(networkName));
    }

    private long getLongTime(String networkID) {
        if (networkID.startsWith(ConstantsEc2.NETWORD_ID_PREFIX)) {
            String ts = networkID.substring(ConstantsEc2.NETWORD_ID_PREFIX.length());
            return Long.parseLong(ts);
        }
        throw new RuntimeException("BAD networkID=" + networkID);
    }

    private List<String> getInstanceIDsFor(NetworkInfo ni) {
        ArrayList<String> iids = new ArrayList<String>();
        List<InstanceStatus> ists = this.getInstances(ni);
        for (InstanceStatus s : ists) {
            iids.add(s.instance.getInstanceId());
        }
        return iids;
    }

    private HashMap<String, String> getSpotInstanceRequestIDs(RequestSpotInstancesResult rr) {
        HashMap<String, String> ht = new HashMap<String, String>();
        for (SpotInstanceRequest s : rr.getSpotInstanceRequests()) {
            String ID = s.getSpotInstanceRequestId();
            ht.put(ID, ID);
        }
        return ht;
    }

    private List<String> getIIDsForSpotRequest(HashMap<String, String> sirHt) {
        try {
            ArrayList<String> iids = new ArrayList<String>();
            DescribeSpotInstanceRequestsResult drr = this.ec2Client.describeSpotInstanceRequests();
            List sirs = drr.getSpotInstanceRequests();
            for (SpotInstanceRequest r : sirs) {
                String ID;
                if (!sirHt.containsKey(r.getSpotInstanceRequestId()) || (ID = r.getInstanceId()) == null) continue;
                iids.add(ID);
            }
            return iids;
        }
        catch (AmazonClientException acx) {
            System.err.println("Exception in Ec2Wrangler.getSpotInstanceRequestIIDs(): " + acx.getMessage() + "  - we'll try again.");
            return new ArrayList<String>();
        }
    }

    private boolean allRunning(List<InstanceStatus> insL, int nInstancesExpected) {
        if (insL.size() < nInstancesExpected) {
            return false;
        }
        int n = 0;
        for (InstanceStatus s : insL) {
            if (!s.isRunning()) continue;
            ++n;
        }
        return n >= nInstancesExpected;
    }

    private boolean allRunning(RunInstancesResult rr) {
        try {
            List<Instance> extantInstances = this.getAllUsersInstances();
            DescribeInstancesResult ir = this.ec2Client.describeInstances();
            for (Instance ins : rr.getReservation().getInstances()) {
                Instance x = this.getMatchingInstance(extantInstances, ins);
                if (x == null) {
                    return false;
                }
                if (InstanceStatus.isRunning(x)) continue;
                return false;
            }
            return true;
        }
        catch (Exception xxx) {
            ExceptionHandler.display(xxx);
            return false;
        }
    }

    private Instance getMatchingInstance(List<Instance> list, Instance ins) {
        for (Instance x : list) {
            if (!x.getInstanceId().equals(ins.getInstanceId())) continue;
            return x;
        }
        return null;
    }

    public boolean isHVM(String imageID) {
        DescribeImagesRequest req = new DescribeImagesRequest();
        ArrayList<String> iids = new ArrayList<String>();
        iids.add(imageID);
        req.setImageIds(iids);
        DescribeImagesResult res = this.ec2Client.describeImages(req);
        for (Image img : res.getImages()) {
            if (!img.getImageId().equals(imageID)) continue;
            return img.getVirtualizationType().equals("hvm");
        }
        return false;
    }

    private void setupClusterPlacementGroup(RunInstancesRequest req) {
        String clusterName = this.params.clusterGroupName != null ? this.params.clusterGroupName : ConstantsEc2.CLUSTER_GROUP_DEFAULT;
        this.createClusterGroupIfNecessary(clusterName);
        Placement placement = new Placement();
        placement.setGroupName(clusterName);
        req.setPlacement(placement);
    }

    private void setupClusterPlacementGroup(LaunchSpecification spec) {
        String clusterName = this.params.clusterGroupName != null ? this.params.clusterGroupName : ConstantsEc2.CLUSTER_GROUP_DEFAULT;
        this.createClusterGroupIfNecessary(clusterName);
        SpotPlacement placement = new SpotPlacement();
        placement.setGroupName(clusterName);
        spec.setPlacement(placement);
    }

    private void createClusterGroupIfNecessary(String name) {
        DescribePlacementGroupsResult r = this.ec2Client.describePlacementGroups();
        for (PlacementGroup pg : r.getPlacementGroups()) {
            if (!pg.getGroupName().equals(name)) continue;
            System.out.println("Ec2W: found extant placement  group=" + name);
            return;
        }
        CreatePlacementGroupRequest req = new CreatePlacementGroupRequest();
        req.setGroupName(name);
        req.setStrategy("cluster");
        this.ec2Client.createPlacementGroup(req);
        System.out.println("Ec2W: create placement group name=" + name);
    }

    private void deleteClusterGroupIfNecessary() {
        try {
            if (this.params.clusterGroupName != null) {
                return;
            }
            if (this.placementGroupExists(ConstantsEc2.CLUSTER_GROUP_DEFAULT)) {
                DeletePlacementGroupRequest req = new DeletePlacementGroupRequest(ConstantsEc2.CLUSTER_GROUP_DEFAULT);
                this.ec2Client.deletePlacementGroup(req);
            }
        }
        catch (Exception xxx) {
            ExceptionHandler.display(xxx);
        }
    }

    private boolean placementGroupExists(String name) {
        DescribePlacementGroupsResult r = this.ec2Client.describePlacementGroups();
        for (PlacementGroup g : r.getPlacementGroups()) {
            if (!g.getGroupName().equals(g)) continue;
            return true;
        }
        return false;
    }
}

