% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_climate.R
\name{download_climate}
\alias{download_climate}
\title{download climate data of the world}
\usage{
download_climate(url)
}
\arguments{
\item{url}{A String to specify target html.}
}
\value{
A tibble including climate and station information, or NULL when failed.
}
\description{
For polite scraping, 5 sec interval is set in download_climate(),
it takes over 5 hours to get climate data of all stations.
Please use existing links by "data(world_climate)",
if you do not need to renew climate data.
You can see web page as below.
https://www.data.jma.go.jp/gmd/cpd/monitor/nrmlist/
}
\examples{
# If you want all climate data, remove head().
# The codes take > 5 sec because of poliste scraping.
\donttest{
library(tidyverse)
data(station_links)
station_links <-
  station_links \%>\%
  head(1) \%>\%
  `$`("url")

climate <- list()
for(i in seq_along(station_links)){
  print(stringr::str_c(i, " / ", length(station_links)))
  climate[[i]] <- download_climate(station_links[i])
}
world_climate <- dplyr::bind_rows(climate)
world_climate
}
}
