% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cld2.R
\name{cld2}
\alias{cld2}
\alias{detect_language}
\alias{detect_language_multi}
\title{Compact Language Detector 2}
\usage{
detect_language(text, plain_text = TRUE)

detect_language_multi(text, plain_text = TRUE)
}
\arguments{
\item{text}{a string with text to classify or a connection to read from}

\item{plain_text}{if \code{FALSE} then code skips HTML tags and expands HTML entities}
}
\description{
The function \code{\link[=detect_language]{detect_language()}} guesses the language of \code{text} or returns \code{NA}
if the language could not reliably be determined. The function \code{\link[=detect_language_multi]{detect_language_multi()}}
shows the top 3 guessed languages including a relative probability score, and also shows
the total number of text bytes that was reliably classified.
}
\examples{
# Read text
detect_language("To be or not to be")
detect_language("Ce n'est pas grave.")
detect_language("Nou breekt mijn klomp!")

\dontrun{
# Read HTML from connection
detect_language(url('http://www.un.org/ar/universal-declaration-human-rights/'), plain_text = FALSE)

# More detailed classification output
detect_language_multi(
  url('http://www.un.org/fr/universal-declaration-human-rights/'), plain_text = FALSE)

detect_language_multi(
  url('http://www.un.org/zh/universal-declaration-human-rights/'), plain_text = FALSE)
}
}
