% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity_classification.R
\name{entity_classification}
\alias{entity_classification}
\title{Entity Classification}
\usage{
entity_classification(inchi_key)
}
\arguments{
\item{inchi_key}{a character string of a valid InChIKey}
}
\value{
a \code{tibble} containing the following;
\itemize{
\item \strong{Level} Classification level (kingdom, superclass, class and subclass)
\item \strong{Classification} The compound classification
\item \strong{CHEMONT} Chemical Ontology Identification code
}
}
\description{
Retrieve entity classification from `http://classyfire.wishartlab.com/entities/'
}
\examples{

# Valid InChI key where all four classification levels are available
entity_classification('BRMWTNUJHUMWMS-LURJTMIESA-N')

# Valid InChI key where only three classification levels are available
entity_classification('MDHYEMXUFSJLGV-UHFFFAOYSA-N')

# Invalid InChI key
entity_classification('MDHYEMXUFSJLGV-UHFFFAOYSA-B')


# Using `dplyr` a vector of InChI Keys can be submitted and easily parsed
  library(dplyr)
  library(purrr)
  library(tidyr)

 keys <- c(
'BRMWTNUJHUMWMS-LURJTMIESA-N',
'XFNJVJPLKCPIBV-UHFFFAOYSA-N',
'TYEYBOSBBBHJIV-UHFFFAOYSA-N',
'AFENDNXGAFYKQO-UHFFFAOYSA-N',
'WHEUWNKSCXYKBU-QPWUGHHJSA-N',
'WHBMMWSBFZVSSR-GSVOUGTGSA-N')

 classification_list <- map(keys, entity_classification)

 classification_list <- map(classification_list, ~{select(.,-CHEMONT)})

 spread_tibble <- purrr:::map(classification_list, ~{
                  spread(., Level, Classification)
                  }) \%>\% bind_rows() \%>\% data.frame()

 rownames(spread_tibble) <- keys

 classification_df <-  data.frame(InChIKey = rownames(spread_tibble),
                               Kingdom = spread_tibble$kingdom,
                                SuperClass = spread_tibble$superclass,
                                Class = spread_tibble$class,
                                SubClass = spread_tibble$subclass)

 print(classification_df)



}
