% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/related_update.R
\name{related_update}
\alias{related_update}
\title{Update a related item}
\usage{
related_update(
  id,
  title,
  type,
  description = NULL,
  related_id = NULL,
  related_url = NULL,
  image_url = NULL,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) id of related item to update. This should be an
alphanumeric string. Required.}

\item{title}{(character) Title of the related item. Required.}

\item{type}{(character) The type of the related item. One of API,
application, idea, news article, paper, post or visualization. Required.}

\item{description}{(character) description (optional). Optional}

\item{related_id}{(character) An id to assign to the related item. If blank,
an ID will be assigned for you. Optional}

\item{related_url}{(character) A url to associated with the related item.
Optional}

\item{image_url}{(character) A url to associated image. Optional}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Update a related item
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package and related item
res <- package_create("hello-saturn2") \%>\%
   related_create(title = "my resource",
                  type = "visualization")

# update the related item
related_update(res, title = "her resource", type = "idea")
}
}
