% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_mgcv.R
\name{SL.mgcv}
\alias{SL.mgcv}
\title{Wrapper for mgcv's gam implementation}
\usage{
SL.mgcv(
  Y,
  X,
  newX,
  family,
  obsWeights = NULL,
  id = NULL,
  degree = -1,
  continuous_values = 5,
  smooth_fn = "s",
  exclude_spline = NULL,
  method = "REML",
  select = TRUE,
  gamma = 1,
  formula_rhs = NULL,
  ...
)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Covariate dataframe}

\item{newX}{Optional dataframe to predict the outcome}

\item{family}{"gaussian" for regression, "binomial" for binary
classification}

\item{obsWeights}{Optional observation-level weights (supported but not tested)}

\item{id}{Optional id to group observations from the same unit (not used
currently).}

\item{degree}{Dimension of the basis expansion, default 2.}

\item{continuous_values}{Variables with this or more unique values are
considered continuous and will be incorporated as spline terms.}

\item{smooth_fn}{"s", "te", "ti", or "t2"}

\item{exclude_spline}{Variable names for which not to spline, even if they
meet the continuous variable definition.}

\item{method}{"REML" (default), "GCV.Cp", "GACV.Cp", "P-REML", "ML", "P-ML"}

\item{select}{If covariates can be removed entirely due to a penalty.}

\item{gamma}{Gamma setting, default 1.}

\item{formula_rhs}{Custom RHS formula, if built-in options are insufficient.}

\item{...}{Any remaining arguments, not used.}
}
\description{
Wrapper for mgcv's gam implementation.
}
\references{
Wood S.N. (2006b) Generalized Additive Models: An Introduction with R.
Chapman and Hall/CRC Press.

Hastie and Tibshirani (1990) Generalized Additive Models. Chapman and Hall.

Wahba (1990) Spline Models of Observational Data. SIAM

Green and Silverman (1994) Nonparametric Regression and Generalized Linear
Models. Chapman and Hall.
}
\seealso{
\code{\link[mgcv]{gam}}
}
