% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{media_list_optimizations}
\alias{media_list_optimizations}
\title{List all optimizations}
\usage{
media_list_optimizations(archived = NULL, limit = NULL, page_num = NULL,
  order = NULL, order_dir = NULL)
}
\arguments{
\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to created_at. Must be one of: created_at, author, name.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The optimization ID.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{name}{string, The name of the optimization.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{finishedAt}{string, The end time of the last run.}
\item{state}{string, The state of the last run.}
\item{lastRunId}{integer, The ID of the last run.}
\item{spotOrderId}{integer, The ID for the spot order produced by the optimization.}
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
List all optimizations
}
