% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_get_kubernetes}
\alias{clusters_get_kubernetes}
\title{Describe a Kubernetes Cluster}
\usage{
clusters_get_kubernetes(id)
}
\arguments{
\item{id}{integer required. The ID of this cluster.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this cluster.}
\item{instanceTypes}{array, An array containing the following fields: 
\itemize{
\item type string, An EC2 instance type.
\item minInstances integer, The minimum number of instances of that type in this cluster.
\item maxInstances integer, The maximum number of instances of that type in this cluster.
\item instanceMaxMemory integer, The amount of memory available to a single instance of that type.
\item instanceMaxCpu integer, The number of processor shares available to a single instance of that type.
}}
\item{defaultInstanceType}{string, Deprecated. The default EC2 instance type in this cluster.}
\item{organizationId}{string, The id of this cluster's organization.}
\item{organizationSlug}{string, The slug of this cluster's organization.}
\item{securityGroupId}{string, The security group to be added to the nodes of this cluster}
\item{clusterPartitions}{array, An array containing the following fields: 
\itemize{
\item clusterPartitionId integer, The ID of this cluster partition.
\item name string, The name of the cluster partition.
\item labels array, Labels associated with this partition.
\item instanceConfigs array, The instances configured for this cluster partition.
\item defaultInstanceConfigId integer, The id of the InstanceConfig that is the default for this partition.
}}
\item{isNatEnabled}{boolean, Whether this cluster needs a NAT gateway or not.}
}
\description{
Describe a Kubernetes Cluster
}
