% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue_training.R
\name{continue_training}
\alias{continue_training}
\title{Continues training of a model for additional periods}
\usage{
continue_training(
  model,
  epochs = 32,
  continue_from = NULL,
  data = NULL,
  device = "cpu",
  verbose = TRUE,
  changed_params = NULL
)
}
\arguments{
\item{model}{a model created by \code{\link{dnn}}}

\item{epochs}{additional epochs the training should continue for}

\item{continue_from}{define which epoch should be used as starting point for training, 0 if last epoch should be used}

\item{data}{matrix or data.frame if not provided data from original training will be used}

\item{device}{device on which network should be trained on, either "cpu" or "cuda"}

\item{verbose}{print training and validation loss of epochs}

\item{changed_params}{list of arguments to change compared to original training setup, see \code{\link{dnn}} which parameter can be changed}
}
\value{
a model of class cito.dnn same as created by  \code{\link{dnn}}
}
\description{
Continues training of a model for additional periods
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

set.seed(222)
validation_set<- sample(c(1:nrow(datasets::iris)),25)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris[-validation_set,], epochs = 32)

# continue training for another 32 epochs
nn.fit<- continue_training(nn.fit,epochs = 32)

# Use model on validation set
predictions <- predict(nn.fit, iris[validation_set,])
}
}
}
