% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{browse_circle_token}
\alias{browse_circle_token}
\title{Authenticate to Circle CI}
\usage{
browse_circle_token()
}
\value{
Returns \code{TRUE} (invisibly).
}
\description{
A Circle CI API token is needed to interact with the Circle CI API.
\code{browse_circle_token()} opens a browser window for the respective Circle CI
endpoint to retrieve the key.
}
\section{Store API token}{


\code{circle} supports two ways of storing the Circle API tokens:
\itemize{
\item via env vars \code{R_CIRCLE}
\item via \verb{~/.circleci/cli.yml}
}

The latter should already be present if you already used the \code{circle} CLI
tool at some point in the past. If not, its up to your preference which
approach to use.

The following instructions should help to set up \verb{~/.circleci/cli.yml}
correctly:
\enumerate{
\item Copy the token from the browser after having called
\code{browse_circle_token()}. You can use
\code{edit_circle_config()} to open \verb{~/.circleci/cli.yml}.
\item The token should be stored using the following structure

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{host: https://circleci.com
endpoint: graphql-unstable
token: <token>
}\if{html}{\out{</div>}}
}
}

\examples{
\dontrun{
browse_circle_token()

edit_circle_config()
}
}
