% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPlotFunctions.R
\name{plot_meancompare.circGLM}
\alias{plot_meancompare.circGLM}
\title{Plot mean comparisons for a circGLM object}
\usage{
plot_meancompare.circGLM(m, alpha = 0.7, xlab = "Mean direction")
}
\arguments{
\item{m}{A \code{circGLM} object.}

\item{alpha}{The transparency (alpha) of the plotted densities.}

\item{xlab}{The label of the x-axis.}
}
\description{
If the main predictors of interest for the circGLM are categorical, it can be
insightful to plot the posteriors of the group means side-by-side, which this
function does. This is particularly useful for ANOVA or ANCOVA type designs.
}
\details{
If there are linear predictors in the model as well, the posteriors displayed
will correspond to the intercept parameter for each group.
}
\examples{
dat <- generateCircGLMData(nconpred = 0)
m   <- circGLM(th ~ ., dat)
plot_meancompare.circGLM(m)
}
\seealso{
\code{\link{plot_trace.circGLM}},
  \code{\link{plot_tracestack.circGLM}},
  \code{\link{plot_predict.circGLM}},
  \code{\link{plot_meanboxplot.circGLM}},
  \code{\link{plot.circGLM}}.
}
