% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{reader methods}
\alias{reader methods}
\alias{next_chunk}
\alias{next_chunk,reader-method}
\alias{next_chunk,reader-methods}
\alias{get_matrix}
\alias{get_matrix,reader-method}
\alias{get_matrix,reader-methods}
\alias{get_dataframe}
\alias{get_dataframe,reader-method}
\alias{get_dataframe,}
\alias{reader-methods}
\alias{get_completed}
\alias{get_completed,reader-method}
\alias{get_completed,reader-methods}
\alias{get_colnames}
\alias{get_colnames,reader-method}
\title{Manipulation methods for reader objects}
\usage{
next_chunk(obj)

\S4method{next_chunk}{reader}(obj)

get_matrix(obj)

\S4method{get_matrix}{reader}(obj)

get_dataframe(obj)

\S4method{get_dataframe}{reader}(obj)

get_completed(obj)

\S4method{get_completed}{reader}(obj)

get_colnames(obj)

\S4method{get_colnames}{reader}(obj)
}
\arguments{
\item{obj}{object of class reader}
}
\description{
Reader objects can be manipulated with the following methods:
\enumerate{
\item{\bold{next_chunk}}{: allows to read the next chunk of a reader object}
\item{\bold{get_matrix}}{: retrieve the current data chunk contained in the object, as matrix}
\item{\bold{get_dataframe}}{: retrieves the current data chunk, as a data frame} 
}

In addition, this information can be retrieved from reader objects:
\enumerate{
\item{\bold{get_completed}}{: get the number of rows already read}
\item{\bold{get_colnames}}{: get column names of the reader object}
}
}
\details{
See \code{\link{reader}} for examples.
}
