% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_metadata.R
\name{normalize_data}
\alias{normalize_data}
\title{Normalize peak table or chromatograms}
\usage{
normalize_data(
  peak_table,
  column,
  chrom_list,
  what = c("peak_table", "chrom_list")
)
}
\arguments{
\item{peak_table}{A `peak_table` object}

\item{column}{The name of the column containing the weights.}

\item{chrom_list}{List of chromatograms for normalization. The samples must
be in same order as the peak_table.}

\item{what}{`peak_table` or list of chromatograms (`chrom_list`).}
}
\value{
A \code{peak_table} object where the peaks are normalized by the mass
of each sample.
}
\description{
Normalizes peak table or list of chromatograms by specified column in sample
meta-data. Metadata must first be attached to \code{peak_table} using
\code{\link{attach_metadata}}.
}
\examples{
data(pk_tab)
path <- system.file("extdata", "Sa_metadata.csv", package = "chromatographR")
meta <- read.csv(path)
pk_tab <- attach_metadata(peak_table = pk_tab, metadata = meta, column="vial")
norm <- normalize_data(pk_tab, "mass", what = "peak_table")
}
\seealso{
\code{\link{get_peaktable}} \code{\link{attach_metadata}}
}
\author{
Ethan Bass
}
