% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init-helper.R
\name{.init_helper}
\alias{.init_helper}
\title{Initialize a Helper object}
\usage{
.init_helper(chore = NULL, .chores_chat = getOption(".chores_chat"))
}
\arguments{
\item{chore}{The identifier for a helper prompt. By default one
of \link[=cli_helper]{"cli"}, \link[=testthat_helper]{"testthat"} or \link[=roxygen_helper]{"roxygen"},
though custom helpers can be added with \code{\link[=prompt_new]{prompt_new()}}.}

\item{.chores_chat}{An ellmer Chat, e.g.
\code{function() ellmer::chat_claude()}. Defaults to the option by the same name,
so e.g. set \code{options(.chores_chat = ellmer::chat_claude())} in your
\code{.Rprofile} to configure chores with ellmer every time you start a new R session.}
}
\value{
A Helper object, which is a subclass of an ellmer chat.
}
\description{
\strong{Users typically should not need to call this function.}
\itemize{
\item Create new helpers that will automatically be registered with this function
with \code{\link[=prompt_new]{prompt_new()}}.
\item The \link[=.init_addin]{chores addin} will initialize needed helpers on-the-fly.
}
}
\examples{
# requires an API key and sets options
\dontrun{
# to create a chat with claude:
.init_helper(.chores_chat = ellmer::chat_claude())

# or with OpenAI's 4o-mini:
.init_helper(.chores_chat = ellmer::chat_openai(model = "gpt-4o-mini"))

# to set OpenAI's 4o-mini as the default model powering chores, for example,
# set the following option (possibly in your .Rprofile, if you'd like
# them to persist across sessions):
options(
  .chores_chat = ellmer::chat_openai(model = "gpt-4o-mini")
)
}
}
