% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_make_balanced}
\alias{par_make_balanced}
\title{Generate groups based on balanced clustering}
\usage{
par_make_balanced(points_in = NULL, n_clusters = NULL)
}
\arguments{
\item{points_in}{\code{sf} or \code{SpatVector} object. Target points of computation.}

\item{n_clusters}{integer(1). The number of clusters.}
}
\value{
\code{SpatVector} object with a field \code{"CGRIDID"}.
}
\description{
For balancing computational loads, the function uses
the \code{anticlust} package to cluster the input points. The number of clusters
is determined by the \code{num_cluster} argument. Each cluster will have
equal number of points. Grids will be generated based on the cluster
extents. At the lower level, the function uses \code{\link[terra:distance]{terra::distance()}}
function to calculate the Euclidean distance between points.
}
\note{
This function is only for two-dimensional points.
The results will be irregular grids with or without overlapping parts.
}
\author{
Insang Song
}
\keyword{internal}
