% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-dbl.R
\name{chk_dbl}
\alias{chk_dbl}
\alias{vld_dbl}
\title{Check Double Scalar}
\usage{
chk_dbl(x, x_name = NULL)

vld_dbl(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if double scalar using

\code{is.double(x) && length(x) == 1L}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\section{Functions}{
\itemize{
\item \code{vld_dbl}: Validate Double

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}}

\examples{
# chk_dbl
chk_dbl(1)
try(chk_dbl(1L))
# vld_dbl
vld_dbl(1)
vld_dbl(double(0))
vld_dbl(NA_real_)
vld_dbl(c(1, 1))
vld_dbl(1L)
}
\seealso{
Other deprecated: 
\code{\link{chk_chr}()},
\code{\link{chk_deprecated}},
\code{\link{chk_wnum}()}
}
\concept{deprecated}
