% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-names.R
\name{check_names}
\alias{check_names}
\title{Check Names}
\usage{
check_names(
  x,
  names = character(0),
  exclusive = FALSE,
  order = FALSE,
  x_name = NULL
)
}
\arguments{
\item{x}{The object to check.}

\item{names}{A character vector of the required names.}

\item{exclusive}{A flag specifying whether x must only contain the required names.}

\item{order}{A flag specifying whether the order of the required names in x must match the order in names.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks the names of an object.
}
\examples{
x <- c(x = 1, y = 2)
check_names(x, c("y", "x"))
try(check_names(x, c("y", "x"), order = TRUE))
try(check_names(x, "x", exclusive = TRUE))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_dim}()},
\code{\link{check_dirs}()},
\code{\link{check_files}()},
\code{\link{check_key}()},
\code{\link{check_values}()}
}
\concept{check}
