% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_speedglm.R
\name{chest_speedglm}
\alias{chest_speedglm}
\title{Assessing confounding effects using Generalized Linear regression models}
\usage{
chest_speedglm(
  crude,
  xlist,
  data,
  family = binomial(),
  method = c("eigen", "Cholesky", "qr"),
  na_omit = TRUE,
  plus = "  + ",
  indicate = FALSE,
  ...
)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with all variable names of potential confounders.}

\item{data}{\emph{Data frame}.}

\item{family}{Description of the error distribution. Default is \emph{"binomial"}.}

\item{method}{Method to detect for singularity.}

\item{na_omit}{Remove all missing values, default: 'na_omit = TRUE'.}

\item{plus}{Change the \code{+} sign before variable names.}

\item{indicate}{indicate progress}

\item{...}{Further optional arguments for speedglm.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
This is a faster option to 'chest_glm'.
It presents the effect estimates (such as \emph{odds ratios}) for the association between exposure and outcome variables by adding other variables (potential confounders) to the model sequentially.
The order of variables to be added is based on the magnitudes of the changes in effect estimates. It returns a graph and a table with effect estimates, 95\% confidence intervals and changes (\%) at different steps.
}
\examples{
vlist<-c("Age", "Sex", "Married", "Cancer", "CVD", "Education", "Income")
chest_speedglm(crude = "Endpoint ~ Diabetes",
              xlist = vlist, na_omit=TRUE, data = diab_df)
 # adding derived terms such as an interaction between Age and Sex, and age squared:
diab_df$Age_Sex = diab_df$Age*diab_df$Sex
diab_df$Age2 = diab_df$Age^2
vlist<-c("Age", "Sex", "Age2", "Age_Sex", "Married", "Cancer", "CVD", "Education", "Income")
chest_speedglm(crude = "Endpoint ~ Diabetes", xlist = vlist, na_omit=TRUE, data = diab_df)
}
\seealso{
\pkg{'speedglm'}

\code{'glm'} of \pkg{'stats'}
}
