% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{movingEnergyDistance}
\alias{movingEnergyDistance}
\title{Moving energy distance}
\usage{
movingEnergyDistance(x, y, l = NULL, tau = NULL, alpha = 1)
}
\arguments{
\item{x}{matrix of regressors with variables in columns and observations in rows}

\item{y}{matrix of responses with variables in columns and observations in rows}

\item{l}{approximate number of contributing variables (Default : overall number of regressors)}

\item{tau}{length of a splitting period (Default: l*10, which is dictated by The general rule of thumb \insertCite{Harrell}{changedetection})}

\item{alpha}{parameter for energy distance formula (default: `1`)}
}
\value{
a list of energy distnce values for pairs of adjacent data segments of length tau (moving-frame construction)
}
\description{
Estimates energy distance \insertCite{rizzo-szekely10}{changedetection} for each point starting from \code{tau+1} to \code{T-tau}, where \code{T} is a data length. In these terms, energy distance for a point means energy distance between the dataset containing \code{tau} observations to the left and the dataset containing \code{tau} observations to the right of the original point. Hence, we are considering a so-called 'moving frame' of length \code{2tau}. The resulting array shows how the energy distance behaves along the period to analyze.
}
\examples{
T<-60
change<-35
x<-rnorm(n=T, m=0, sd=1)
e<-scale(rt(n=T,3), scale=FALSE)
y1<-5*x[1:(change-1)]+e[1:(change-1)]
y2<--2*x[change:T]+e[change:T]
y<-c(y1,y2)

med <- movingEnergyDistance(x=as.data.frame(x),
                            y=as.data.frame(y))
}
\references{
\insertAllCited
}
