% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{cg_input}
\alias{cg_input}
\title{Add Input}
\usage{
cg_input(name = NULL)
}
\arguments{
\item{name}{character scalar, name of the node (optional). In case argument \code{name} is missing, the node is added to the graph under an automatically generated name.}
}
\value{
cg_node object.
}
\description{
Add an input node to the active graph.
}
\note{
Inputs cannot be assigned a value upon creation. Instead, they behave as placeholders. You can use data member \code{value} of a cg_node object to retrieve or change its value.
}
\examples{
# Initialize a computational graph
graph <- cg_graph()

# Add an input with name 'a' to the graph.
a <- cg_input(name = "a")

# Set the value to 2
a$value <- 2

}
\author{
Ron Triepels
}
