% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_period.R
\name{latent_period}
\alias{latent_period}
\title{Calculate Cercospora Latent Period}
\usage{
latent_period(Tm, ref = "wolf")
}
\arguments{
\item{Tm}{numeric, Average temperature in degrees Celsius for a hour of the day}

\item{ref}{character, method for calculating latent period. Default is
\code{"wolf"} also available \code{"jarroudi"}. See references for where
formulas were used}
}
\value{
numeric, Latent period for a given hour. \code{ref = "jarroudi"}
returns latent period in days.
}
\description{
Calculate Cercospora Latent Period
}
\details{
Calculates the latent period for \emph{Cercospora beticola} infections on
sugar beet. Note the published formula in Wolf and Verreet (2005)
contains an error in the exponent. e(0.35 x (Tm - 10)) should be
e(-0.35 x (Tm - 10)). See issue #22 on Github for additional information.
}
\references{
Wolf, P. F. J., and J. A. Verreet. “Factors Affecting the Onset of Cercospora
Leaf Spot Epidemics in Sugar Beet and Establishment of Disease-Monitoring
Thresholds.” \emph{Phytopathology®} 95, no. 3 (March 2005): 269–74.
https://doi.org/10.1094/PHYTO-95-0269.

El Jarroudi, Moussa, Fadia Chairi, Louis Kouadio, Kathleen Antoons,
Abdoul-Hamid Mohamed Sallah, and Xavier Fettweis. “Weather-Based Predictive
Modeling of Cercospora Beticola Infection Events in Sugar Beet in Belgium.”
\emph{Journal of Fungi} 7, no. 9 (September 18, 2021): 777.
https://doi.org/10.3390/jof7090777.
}
