% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotorSpeed.R
\name{rotorSpeed}
\alias{rotorSpeed}
\title{Calculate RPM/RCF}
\usage{
rotorSpeed(radius, value, type)
}
\arguments{
\item{radius}{a numeric, the centrifugal radius in millimeters.}

\item{value}{a numeric, the rotational speed in revolutions per minute or the
relative centrifuge force in × g.}

\item{type}{the type of the above-mentioned \code{value}, "rpm" for
rotational speed or "rcf" for relative centrifuge force.}
}
\value{
\code{rotorSpeed} returns a numeric that is the rotational speed in
  revolutions per minute or the relative centrifuge force in × g.
}
\description{
\code{rotorSpeed} converts rotational speed to relative centrifuge force and vice versa.
}
\examples{
rotorSpeed(100, 12000, "rpm")
rotorSpeed(100, 6000, "rcf")

}
\references{
Rickwood D, editor. Centrifugation: a practical approach. London:
  Information Retrieval Ltd; 1978. 224 p.
}
