% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotorCheck.R
\name{rotorCheck}
\alias{rotorCheck}
\title{Check Centrifuge Rotors}
\usage{
rotorCheck(n, k = NULL)
}
\arguments{
\item{n}{an integer, the number of rotor buckets.}

\item{k}{an integer, the number of tubes.}
}
\value{
\code{rotorCheck} returns a list with two components:
  \item{\code{valid}}{a vector containing the numbers of tubes that can be
  loaded.} \item{\code{invalid}}{a vector containing the numbers of tubes
  that cannot be loaded.}
}
\description{
\code{rotorCheck} returns the numbers of tubes that can and cannot be loaded
in centrifuge rotors.
}
\details{
The number of rotor buckets \code{n} ranges from \code{4} to
  \code{48}. \cr\cr If \code{k} is specified, \code{rotorCheck} will check
  whether the input number of tubes can be loaded or not.
}
\examples{
rotorCheck(30)
rotorCheck(30, 19)
}
\references{
Sivek G. On vanishing sums of distinct roots of unity. Integers.
  2010;10(3):365-8.
}
\seealso{
\code{\link{rotorEqual}} for balancing tubes of equal mass and
  \code{\link{rotorUnequal}} for balancing tubes of unequal mass.
}
