% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partykit.R
\name{party_internal}
\alias{party_internal}
\alias{survival_prob_cforest}
\alias{survival_prob_ctree}
\title{Internal helper functions for party objects}
\usage{
survival_prob_cforest(object, new_data, time, output = "surv")

survival_prob_ctree(object, new_data, time, output = "surv")
}
\arguments{
\item{object}{A model object from \code{partykit::ctree()} or \code{partykit::cforest()}.}

\item{new_data}{A data frame to be predicted.}

\item{time}{A vector of times to predict the survival probability.}

\item{output}{Type of output.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
Internal helper functions for party objects
}
\examples{
library(partykit)
c_forest <- cforest(Surv(time, status) ~ age + ph.ecog, data = lung, ntree = 10)
survival_prob_cforest(c_forest, lung[1:3, ], time = 100)
c_tree <- ctree(Surv(time, status) ~ age + ph.ecog, data = lung)
survival_prob_ctree(c_tree, lung[1:3, ], time = 100)
}
\keyword{internal}
