#ifndef CEC2013_FUNCTIONS_H_
#define CEC2013_FUNCTIONS_H_

#include "consts.h"
#include <malloc.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "globals.h"


void cec2013_sphere_func(double *, double *, int, double *, double *,
                         int); /* Sphere */
void cec2013_ellips_func(double *, double *, int, double *, double *,
                         int); /* Ellipsoidal */
void cec2013_bent_cigar_func(double *, double *, int, double *, double *,
                             int); /* Discus */
void cec2013_discus_func(double *, double *, int, double *, double *,
                         int); /* Bent_Cigar */
void cec2013_dif_powers_func(double *, double *, int, double *, double *,
                             int); /* Different Powers */
void cec2013_rosenbrock_func(double *, double *, int, double *, double *,
                             int); /* Rosenbrock's */
void cec2013_schaffer_F7_func(double *, double *, int, double *, double *,
                              int); /* Schwefel's F7 */
void cec2013_ackley_func(double *, double *, int, double *, double *,
                         int); /* Ackley's */
void cec2013_rastrigin_func(double *, double *, int, double *, double *,
                            int); /* Rastrigin's  */
void cec2013_weierstrass_func(double *, double *, int, double *, double *,
                              int); /* Weierstrass's  */
void cec2013_griewank_func(double *, double *, int, double *, double *,
                           int); /* Griewank's  */
void cec2013_schwefel_func(double *, double *, int, double *, double *,
                           int); /* Schwefel's */
void cec2013_katsuura_func(double *, double *, int, double *, double *,
                           int); /* Katsuura */
void cec2013_bi_rastrigin_func(double *, double *, int, double *, double *,
                               int); /* Lunacek Bi_rastrigin */
void cec2013_grie_rosen_func(double *, double *, int, double *, double *,
                             int); /* Griewank-Rosenbrock  */
void cec2013_escaffer6_func(double *, double *, int, double *, double *,
                            int); /* Expanded Scaffer's F6  */
void cec2013_step_rastrigin_func(double *, double *, int, double *, double *,
                                 int); /* Noncontinuous Rastrigin's  */
void cec2013_cf01(double *, double *, int, double *, double *,
                  int); /* Composition Function 1 */
void cec2013_cf02(double *, double *, int, double *, double *,
                  int); /* Composition Function 2 */
void cec2013_cf03(double *, double *, int, double *, double *,
                  int); /* Composition Function 3 */
void cec2013_cf04(double *, double *, int, double *, double *,
                  int); /* Composition Function 4 */
void cec2013_cf05(double *, double *, int, double *, double *,
                  int); /* Composition Function 5 */
void cec2013_cf06(double *, double *, int, double *, double *,
                  int); /* Composition Function 6 */
void cec2013_cf07(double *, double *, int, double *, double *,
                  int); /* Composition Function 7 */
void cec2013_cf08(double *, double *, int, double *, double *,
                  int); /* Composition Function 8 */

void cec2013_shiftfunc(double *, double *, int, double *);
void cec2013_rotatefunc(double *, double *, int, double *);
void cec2013_asyfunc(double *, double *x, int, double);
void cec2013_oszfunc(double *, double *, int);
void cec2013_cf_cal(double *, double *, int, double *, double *, double *,
                    double *, int);

#endif // CEC2013_FUNCTIONS_H_
