% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{cbc_inspect}
\alias{cbc_inspect}
\title{Comprehensive design quality inspection}
\usage{
cbc_inspect(design, sections = "all", verbose = FALSE)
}
\arguments{
\item{design}{A \code{cbc_design} object created by \code{cbc_design()}}

\item{sections}{Character vector specifying which sections to show.
Options: "structure", "efficiency", "balance", "overlap", "encoding", or "all" (default).
Can specify multiple: \code{c("balance", "overlap")}}

\item{verbose}{Logical. If TRUE, shows additional technical details.
If FALSE (default), shows simplified output.}
}
\value{
A \code{cbc_inspection} object containing the inspection results
}
\description{
This function provides detailed inspection of choice experiment designs
across multiple dimensions including design structure, efficiency metrics,
attribute balance, overlap patterns, and variable encoding.
}
\examples{
library(cbcTools)

# Create profiles and design
profiles <- cbc_profiles(
  price = c(1, 2, 3),
  type = c("A", "B", "C"),
  quality = c("Low", "High")
)

design <- cbc_design(
  profiles = profiles,
  n_alts = 2,
  n_q = 4
)

# Inspect all sections (default) - prints automatically
cbc_inspect(design)

# Store results for later use
inspection <- cbc_inspect(design, sections = "balance")
inspection  # prints the same output

# Verbose output with technical details
cbc_inspect(design, verbose = TRUE)
}
